package org.linphone.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

public class SessionManager {

    private static final String TAG = "SessionManager";
    private static final String PREF_NAME = "Blue Reach";
    private static final String IS_USER_LOGIN = "IsUserLoggedIn";

    SharedPreferences pref;

    SharedPreferences.Editor editor;

    Context context;

    int PRIVATE_MODE = 0;


    public SessionManager(Context context) {
        this.context = context;
        pref = context.getSharedPreferences(PREF_NAME, PRIVATE_MODE);
        editor = pref.edit();
    }

    /* Login and logout sessions */

    public void setLogin(String key, boolean state) {
        editor.putBoolean(key, state);
        editor.commit();
    }

    public boolean getLoginState(String key) {

        return pref.getBoolean(key, false);
    }

    public boolean isUserLoggedIn() {
        return pref.getBoolean(IS_USER_LOGIN, false);
    }

    public void logoutUser() {

        editor.clear();
        editor.commit();
    }

    public void createUserLoginSession() {
        editor.putBoolean(IS_USER_LOGIN, true);
        editor.commit();
    }


    /* Store languate type value */

    public void setStoreData(String key, String val) {
        Log.d(TAG, "setStoreData() called with: key = [" + key + "], val = [" + val + "]");
        editor.putString(key, val);
        editor.commit();
    }

    public void setBooleanData(String key, boolean value) {

        editor.putBoolean(key, value);
        editor.commit();
    }


    public boolean  getBooleanData(String state){
        return pref.getBoolean(state, false);
    }

    public String getStoreData(String key) {
        return pref.getString(key, "");
    }

    public int getIntData(String key) {
        return pref.getInt(key, 0);
    }

    public void setIntData(String key, int i) {
        editor.putInt(key, i);
        editor.commit();
    }


}