package org.linphone.utils;

import android.app.Activity;
import android.app.Dialog;
import android.graphics.drawable.ColorDrawable;
import android.view.View;
import android.view.Window;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import org.linphone.R;


public class AppAlertsDialog {
    private static final String TAG = "AppAlertsDialog";
    Activity activity_on;
    private AppAlertsDialogListener mListener;


    public AppAlertsDialog(Activity activity) {
        this.activity_on = activity;
        this.mListener = (AppAlertsDialogListener) activity;
    }

    public AppAlertsDialog(Fragment fragment) {
        this.mListener = (AppAlertsDialogListener) fragment;
    }

    public void logoutAlert(final Activity ac, String header, final String status) {

        final SessionManager session = new SessionManager(ac);
        final Dialog dialog = new Dialog(ac);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setBackgroundDrawable(
                new ColorDrawable(android.graphics.Color.TRANSPARENT));
        dialog.setContentView(R.layout.show_logout_popup);

        TextView rec_del_ok_tv = (TextView) dialog
                .findViewById(R.id.logout_okay_tv);
        TextView rec_del_cancle_tv = (TextView) dialog
                .findViewById(R.id.logout_no_tv);
        TextView header_title_tv = (TextView) dialog
                .findViewById(R.id.header_title_tv);
        header_title_tv.setText(header);
        rec_del_ok_tv.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (status.equals("")) {

                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_okay);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_okay,status);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }
                dialog.cancel();

            }
        });
        rec_del_cancle_tv.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                if (status.equals("")) {
                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_cancel);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }else{
                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_cancel,status);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                dialog.cancel();

            }
        });
        dialog.show();

        dialog.setCanceledOnTouchOutside(false);

    }
    public void logoutAlert(final androidx.fragment.app.Fragment ac, String header, final String status) {

        final SessionManager session = new SessionManager(ac.getActivity());
        final Dialog dialog = new Dialog(ac.getActivity());
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setBackgroundDrawable(
                new ColorDrawable(android.graphics.Color.TRANSPARENT));
        dialog.setContentView(R.layout.show_logout_popup);

        TextView rec_del_ok_tv = (TextView) dialog
                .findViewById(R.id.logout_okay_tv);
        TextView rec_del_cancle_tv = (TextView) dialog
                .findViewById(R.id.logout_no_tv);
        TextView header_title_tv = (TextView) dialog
                .findViewById(R.id.header_title_tv);
        header_title_tv.setText(header);
        rec_del_ok_tv.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (status.equals("")) {

                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_okay);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_okay,status);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }
                dialog.cancel();

            }
        });
        rec_del_cancle_tv.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                if (status.equals("")) {
                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_cancel);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }else{
                    try {
                        mListener.onAlertTypeGET(AppIntegers.logout_cancel,status);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                dialog.cancel();

            }
        });
        dialog.show();

        dialog.setCanceledOnTouchOutside(false);

    }


    public interface AppAlertsDialogListener {

        void onAlertTypeGET(int type) throws Exception;

        void onAlertTypeGET(int type, String str) throws Exception;

        void onAlertTypeGET(String type) throws Exception;

    }


}
