package org.linphone.rest;


import android.content.Context;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.SyncHttpClient;

import org.json.JSONObject;

import cz.msebera.android.httpclient.entity.StringEntity;

public class RestBase {

    private static final String BASE_URL = "";

    private static AsyncHttpClient client = new AsyncHttpClient(true ,80,443);
    private static SyncHttpClient syncHttpClient = new SyncHttpClient();


    public static void post1(String url, RequestParams params, String auth_key, AsyncHttpResponseHandler responseHandler) {
        client.post(getAbsoluteUrl(url), params, responseHandler);

    }

    public static void get(Context context, String url, String auth_key, AsyncHttpResponseHandler responseHandler) {
//        client.addHeader(AppStrings.InputParams.token, auth_key);
        client.get(context,getAbsoluteUrl(url), responseHandler);
    }

    public static void post(Context context, String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {


        StringEntity entity = null;
        try {
            entity = new StringEntity(params.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
//        client.addHeader(AppStrings.InputParams.token, auth_key);
        client.post(context, getAbsoluteUrl(url), entity, "application/x-www-form-urlencoded",
                responseHandler);


    }
    public static void postJson(Context context, String url, JSONObject params, AsyncHttpResponseHandler responseHandler) {

        StringEntity entity = null;
        try {
            entity = new StringEntity(params.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        client.post(context, getAbsoluteUrl(url), entity, "application/json",
                responseHandler);
    }
    public static void postSync(String url, RequestParams params, String auth_key, AsyncHttpResponseHandler responseHandler) {
//        client.addHeader("X-Auth-Token", auth_key);
        syncHttpClient.post(getAbsoluteUrl(url), params, responseHandler);
    }

    private static String getAbsoluteUrl(String relativeUrl) {
        return BASE_URL + relativeUrl;
    }
}