package org.linphone.rest;



import android.app.ProgressDialog;
import android.content.Context;
import android.util.Log;

import androidx.fragment.app.Fragment;

import com.loopj.android.http.JsonHttpResponseHandler;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.utils.AppIntegers;

import cz.msebera.android.httpclient.Header;

public class AsyncHttpResponse {
    private static final String TAG = "AsyncHttpResponse";
    private Context context;
    private ProgressDialog progressDialog;
    private boolean isProgressVisible;
    private AsyncHttpResponseListener mListener;

    public AsyncHttpResponse(Context context, boolean isProgressVisible) {
        this.context = context;
        this.isProgressVisible = isProgressVisible;
        this.mListener = (AsyncHttpResponseListener) context;
    }

    public AsyncHttpResponse(Fragment fragment, boolean isProgressVisible) {

        this.context = fragment.getActivity();
        this.isProgressVisible = isProgressVisible;
        this.mListener = (AsyncHttpResponseListener) fragment;

    }

    private void showProgressDialog() {

        if (isProgressVisible) {

            progressDialog = new ProgressDialog(context);
            progressDialog.setMessage("Loading...");
            progressDialog.show();

        }
    }

    private void dismissProgressDialog() {

        if (isProgressVisible) {
            progressDialog.dismiss();
        }
    }

    public String postJsonAsyncHttp(final String URL, final String api_name, final JSONObject postParams) {
        showProgressDialog();
        Log.e(TAG, "postJsonAsyncHttp:URL --->" + URL + "---- postParms--->" + postParams );
        final long firstime = System.currentTimeMillis();
        RestBase.postJson(context, URL, postParams, new JsonHttpResponseHandler() {


            @Override
            public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
                super.onSuccess(statusCode, headers, response);
                dismissProgressDialog();
                Log.e(TAG, "onSuccess:----> " + response);
                float ftime = (System.currentTimeMillis() - firstime) / 1000;


                try {

                    mListener.onAsyncHttpResponseGet(response.toString(), api_name);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onSuccess(int statusCode, Header[] headers, String responseString) {
                super.onSuccess(statusCode, headers, responseString);


                try {

                    mListener.onAsyncHttpResponseGet(responseString.toString(), api_name);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }




            @Override
            public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                super.onFailure(statusCode, headers, throwable, errorResponse);
                try {
                    dismissProgressDialog();

                    if (statusCode == AppIntegers.Unauthorized) {

                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }


            }

            @Override
            public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
                super.onFailure(statusCode, headers, responseString, throwable);
                try {
                    dismissProgressDialog();

                    if (statusCode == AppIntegers.Unauthorized) {

                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }



            }

            @Override
            public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONArray errorResponse) {
                super.onFailure(statusCode, headers, throwable, errorResponse);
                try {
                    dismissProgressDialog();

                    if (statusCode == AppIntegers.Unauthorized) {

                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }

        });
        return null;
    }


    public interface AsyncHttpResponseListener {

        void onAsyncHttpResponseGet(String response, String URL) throws JSONException;
    }
}