package org.linphone.bluereach.handlers;


import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import org.linphone.R;
import org.linphone.bluereach.TimeScheduleActivity;
import org.linphone.bluereach.models.TimeWorkHourModel;

import java.util.ArrayList;


public class TimeWorkHourAdapter extends RecyclerView.Adapter<TimeWorkHourAdapter.ViewHolder> {

    private TimeScheduleActivity activity;
    private ArrayList<TimeWorkHourModel> arralist;

    public TimeWorkHourAdapter(TimeScheduleActivity activity, ArrayList<TimeWorkHourModel> arrayList) {
        this.activity = activity;
        this.arralist = arrayList;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_workhour, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        final TimeWorkHourModel model = arralist.get(position);
        holder.time_workhour_day_tv.setText(model.getDayName());
        holder.time_workhour_from_tv.setText(model.getTimeFrom());
        holder.time_workhour_to_tv.setText(model.getTimeTo());
        holder.setIsRecyclable(false);


        if (model.getDaytype() == 1) {
            holder.time_workhour_day_cb.setChecked(true);
        } else {
            holder.time_workhour_day_cb.setChecked(false);
        }

        holder.time_workhour_day_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                activity.updateDayStatus(position, b, model.getDaytype());
            }
        });


        holder.time_workhour_from_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                /*setting start time based on postion*/

                activity.setFromTime(position);
            }
        });
        holder.from_rl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                activity.setFromTime(position);
            }
        });

        holder.time_workhour_to_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                /*setting end time based on postion*/
                activity.setToTime(position);
            }
        });
        holder.to_rl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                activity.setToTime(position);
            }
        });

        if (position == 0 || position == 8 || position == 16) {
            holder.row_workhour_head_ll.setVisibility(View.VISIBLE);
            holder.row_workhour_desc_ll.setVisibility(View.GONE);


            if (position == 0) {
                holder.header_tv.setText(R.string.work_hours);
            } else if (position == 8) {
                holder.header_tv.setText(R.string.avail_hours);
            } else if (position == 16) {
                holder.header_tv.setText(R.string.user_def_hours);
            }
        } else {
            holder.row_workhour_head_ll.setVisibility(View.GONE);
            holder.row_workhour_desc_ll.setVisibility(View.VISIBLE);
        }


    }

    @Override
    public int getItemCount() {
        return arralist.size();
    }


    public class ViewHolder extends RecyclerView.ViewHolder {
        CheckBox time_workhour_day_cb;
        TextView time_workhour_day_tv, time_workhour_from_tv, time_workhour_to_tv, header_tv;
        LinearLayout row_workhour_head_ll, row_workhour_desc_ll;
        RelativeLayout to_rl, from_rl;

        public ViewHolder(View itemView) {
            super(itemView);
            time_workhour_day_cb = (CheckBox) itemView.findViewById(R.id.time_workhour_day_cb);
            time_workhour_day_tv = (TextView) itemView.findViewById(R.id.time_workhour_day_tv);
            time_workhour_from_tv = (TextView) itemView.findViewById(R.id.time_workhour_from_tv);
            time_workhour_to_tv = (TextView) itemView.findViewById(R.id.time_workhour_to_tv);
            header_tv = (TextView) itemView.findViewById(R.id.header_tv);
            row_workhour_head_ll = (LinearLayout) itemView.findViewById(R.id.row_workhour_head_ll);
            row_workhour_desc_ll = (LinearLayout) itemView.findViewById(R.id.row_workhour_desc_ll);
            to_rl = (RelativeLayout) itemView.findViewById(R.id.to_rl);
            from_rl = (RelativeLayout) itemView.findViewById(R.id.from_rl);

        }
    }
}
