package org.linphone.bluereach.handlers;


import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.textfield.TextInputEditText;


import org.linphone.R;
import org.linphone.bluereach.SimulTaneousActivity;
import org.linphone.bluereach.models.SimulTanModel;
import org.linphone.bluereach.models.SimultanSpinModel;

import java.util.ArrayList;


public class SimulTanAdapter extends RecyclerView.Adapter<SimulTanAdapter.ViewHolder> {

    private static final String TAG = "HuntGroupAdapter";
    private SimulTaneousActivity activity;
    private ArrayList<SimulTanModel> arralist;

    public SimulTanAdapter(SimulTaneousActivity activity, ArrayList<SimulTanModel> arrayList) {
        this.activity = activity;
        this.arralist = arrayList;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_simultan, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        final SimulTanModel model = arralist.get(position);
        holder.simultan_head_tv.setText(model.getHeaderData());
//        holder.simultan_phoneno_tie.setText("");
//        holder.simultan_seconddel_tie.setText("");

        if (model.getEnable_status() == 1) {
            holder.simultan_enable_cb.setChecked(true);
        } else {
            holder.simultan_enable_cb.setChecked(false);
        }

        if (model.getHuntmode_status() == 1) {
            holder.simultan_huntmode_cb.setChecked(true);
        } else {
            holder.simultan_huntmode_cb.setChecked(false);
        }

        holder.simultan_huntmode_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {


                if (isChecked) {
                    activity.updateHunt(position, 1);
                } else {
                    activity.updateHunt(position, 0);
                }
            }
        });

        holder.simultan_enable_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    activity.updateEnab(position, 1);
                } else {
                    activity.updateEnab(position, 0);
                }
            }
        });


        TextWatcher textWatcher_number = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence data, int start, int before, int count) {

                activity.updatePhoneNumber(position, data.toString());

            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        };

        holder.simultan_phoneno_tie.addTextChangedListener(textWatcher_number);

        TextWatcher textWatcher_delay = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence data, int start, int before, int count) {

                activity.updatePhoneDelay(position, data.toString());

            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        };

        holder.simultan_seconddel_tie.addTextChangedListener(textWatcher_delay);

        holder.simultan_phoneno_tie.setText(model.getPhoneNo());
        holder.simultan_seconddel_tie.setText(model.getSecondsDelay());

        holder.simultan_phoneno_tie.setSelection(holder.simultan_phoneno_tie.getText().length());
        holder.simultan_seconddel_tie.setSelection(holder.simultan_seconddel_tie.getText().length());




        setSpinnder(position, holder.simultan_spin);
        holder.simultan_spin.setSelection(model.getSelectedSpinpos());


    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public int getItemCount() {


        return arralist.size();
    }

    public void setSpinnder(final int pos, final AppCompatSpinner spinner) {
        ArrayAdapter<SimultanSpinModel> adapter = new ArrayAdapter<SimultanSpinModel>(activity, R.layout.simple_spinner_dropdown_item, arralist.get(pos).getSimultanSpinArrayList());
        adapter.setDropDownViewResource(R.layout.cust_spinner);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {

                    activity.updateSpin(pos, position);

                if (spinner.isSelected()) {
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        CheckBox simultan_enable_cb, simultan_huntmode_cb;
        TextView simultan_head_tv;
        AppCompatEditText simultan_phoneno_tie, simultan_seconddel_tie;
        AppCompatSpinner simultan_spin;

        public ViewHolder(View itemView) {
            super(itemView);
            simultan_enable_cb = (CheckBox) itemView.findViewById(R.id.simultan_enable_cb);
            simultan_huntmode_cb = (CheckBox) itemView.findViewById(R.id.simultan_huntmode_cb);
            simultan_head_tv = (TextView) itemView.findViewById(R.id.simultan_head_tv);
            simultan_phoneno_tie = (AppCompatEditText) itemView.findViewById(R.id.simultan_phoneno_tie);
            simultan_seconddel_tie = (AppCompatEditText) itemView.findViewById(R.id.simultan_seconddel_tie);
            simultan_spin = (AppCompatSpinner) itemView.findViewById(R.id.simultan_spin);

        }
    }

}

