package org.linphone.bluereach.handlers;



import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import androidx.appcompat.widget.AppCompatEditText;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.textfield.TextInputLayout;

import org.linphone.R;
import org.linphone.bluereach.HuntGroupActivity;
import org.linphone.bluereach.models.HuntGroupModel;

import java.util.ArrayList;


public class HuntGroupAdapter extends RecyclerView.Adapter<HuntGroupAdapter.ViewHolder> {

    private static final String TAG = "HuntGroupAdapter";
    private HuntGroupActivity activity;
    private ArrayList<HuntGroupModel> arralist;
    TextWatcher numberWatcher;

    public HuntGroupAdapter(HuntGroupActivity activity, ArrayList<HuntGroupModel> arrayList) {
        this.activity = activity;
        this.arralist = arrayList;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_huntgroup, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        final HuntGroupModel model = arralist.get(position);

        holder.setIsRecyclable(false);

        holder.row_hungroup_number_tie.setText(model.getHuntGroupNumber());
        holder.row_hungroup_timeout_tie.setText(model.getHuntGroupTimeout());
     holder.row_hungroup_number_tie.setHint(model.getHuntGroupNumberHint());
         numberWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {


                activity.updateDataNumber(position, charSequence.toString());

            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        };
        TextWatcher timeoutWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                activity.updateDataTimeout(position, charSequence.toString());
            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        };


        holder.row_hungroup_number_tie.addTextChangedListener(numberWatcher);
        holder.row_hungroup_timeout_tie.addTextChangedListener(timeoutWatcher);


    }

    @Override
    public void onViewRecycled(ViewHolder holder) {
        holder.row_hungroup_number_tie.removeTextChangedListener(numberWatcher);
        super.onViewRecycled(holder);
    }

    @Override
    public int getItemCount() {
        return arralist.size();
    }


    public class ViewHolder extends RecyclerView.ViewHolder {
        AppCompatEditText row_hungroup_number_tie, row_hungroup_timeout_tie;
       // TextInputLayout number_til;
        public ViewHolder(View itemView) {
            super(itemView);
            row_hungroup_timeout_tie = (AppCompatEditText) itemView.findViewById(R.id.row_hungroup_timeout_tie);
            row_hungroup_number_tie = (AppCompatEditText) itemView.findViewById(R.id.row_hungroup_number_tie);
          // number_til = (TextInputLayout) itemView.findViewById(R.id.row_hungroup_number_tie);

        }
    }

}
