package org.linphone.bluereach;

import static org.linphone.LinphoneApplication.coreContext;

import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatCheckBox;


import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

public class VoiceMailsActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {
    LinearLayout unavailable_message_ll, busy_message_ll, turn_off_vm_ll, prompt_for_mail_box_ll, email_vm_ll;
    CheckBox turn_off_vm_cb, email_vm_cb, prompt_for_mail_box_cb;
    EditText voice_mail_pin_et, call_div_timer_et, send_copy_et, sms_alert_et;
    String turnoff_vm_status = "0", email_vm_status = "0", prompt_for_mail_box_status = "0", call_div_timer_status = "";
    ImageView back_iv;
    TextView title_tv;
    private static final String TAG = "VoiceMailsActivity";
    SessionManager sessionManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_voice_mails);
        init();
    }

    public void init() {

        sessionManager = new SessionManager(this);
        Log.e(TAG, "init123: "+sessionManager.getStoreData(AppStrings.OutputParams.userID) );
        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);
        unavailable_message_ll = (LinearLayout) findViewById(R.id.unavailable_message_ll);
        busy_message_ll = (LinearLayout) findViewById(R.id.busy_message_ll);
        turn_off_vm_ll = (LinearLayout) findViewById(R.id.turn_off_vm_ll);
        prompt_for_mail_box_ll = (LinearLayout) findViewById(R.id.prompt_for_mail_box_ll);
        email_vm_ll = (LinearLayout) findViewById(R.id.email_vm_ll);

        voice_mail_pin_et = (EditText) findViewById(R.id.voice_mail_pin_et);
        call_div_timer_et = (EditText) findViewById(R.id.call_div_timer_et);
        send_copy_et = (EditText) findViewById(R.id.send_copy_et);
        sms_alert_et = (EditText) findViewById(R.id.sms_alert_et);

        turn_off_vm_cb = (CheckBox) findViewById(R.id.turn_off_vm_cb);
        email_vm_cb = (CheckBox) findViewById(R.id.email_vm_cb);
        prompt_for_mail_box_cb = (CheckBox) findViewById(R.id.prompt_for_mail_box_cb);


        unavailable_message_ll.setOnClickListener(this);
        busy_message_ll.setOnClickListener(this);
        turn_off_vm_ll.setOnClickListener(this);
        email_vm_ll.setOnClickListener(this);
        prompt_for_mail_box_ll.setOnClickListener(this);
        back_iv.setOnClickListener(this);

        title_tv.setText(getString(R.string.voice_mail));

        /*check box functionality */
        turnOffMail();
        promopMail();
        voiceMAilsOnly();


        /*performing voicemail action here*/
        getVoiceMailApiCall(RestApis.get_voip_params);




    }

    public void turnOffMail() {
        turn_off_vm_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {


                    if (isChecked) {
                        turnoff_vm_status = AppStrings.Constants.on;
                    } else {
                        turnoff_vm_status = AppStrings.Constants.off;
                    }
            }
        });
    }

    public void voiceMAilsOnly() {
        email_vm_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                    if (isChecked) {

                        email_vm_status = AppStrings.Constants.on;
                    } else {
                        email_vm_status = AppStrings.Constants.off;
                    }
            }
        });
    }

    public void promopMail() {
        prompt_for_mail_box_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                    if (isChecked) {


                        prompt_for_mail_box_status = AppStrings.Constants.on;

                    } else {
                        prompt_for_mail_box_status = AppStrings.Constants.off;
                    }
            }
        });
    }

    public void updateVoiceMailApiCall() {


        if (call_div_timer_et.getText().toString().equals("")) {
            call_div_timer_status = "20";
        } else {
            call_div_timer_status = call_div_timer_et.getText().toString();
        }


        if (AppMethods.isConnectingToInternet(VoiceMailsActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.set_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.VoiceMailInput.voicemail_disable, turnoff_vm_status);
                job.put(AppStrings.VoiceMailInput.voicemail_pin, voice_mail_pin_et.getText().toString());
                job.put(AppStrings.VoiceMailInput.voicemail_mailboxprompt, prompt_for_mail_box_status);
                job.put(AppStrings.VoiceMailInput.voicemail_emailcopy, send_copy_et.getText().toString());
                job.put(AppStrings.VoiceMailInput.voicemail_emailonly, email_vm_status);
                job.put(AppStrings.VoiceMailInput.voicemail_sms_alert, sms_alert_et.getText().toString());
                job.put(AppStrings.VoiceMailInput.diversion_timer, call_div_timer_status);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.set_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(VoiceMailsActivity.this);
        }
    }

    public void getVoiceMailApiCall(String action) {

        if (AppMethods.isConnectingToInternet(VoiceMailsActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.VoiceMailInput.voicemail_disable, AppStrings.VoiceMailInput.voicemail_disable);
                job.put(AppStrings.VoiceMailInput.voicemail_pin, AppStrings.VoiceMailInput.voicemail_pin);
                job.put(AppStrings.VoiceMailInput.voicemail_mailboxprompt, AppStrings.VoiceMailInput.voicemail_mailboxprompt);
                job.put(AppStrings.VoiceMailInput.voicemail_emailcopy, AppStrings.VoiceMailInput.voicemail_emailcopy);
                job.put(AppStrings.VoiceMailInput.voicemail_emailonly, AppStrings.VoiceMailInput.voicemail_emailonly);
                job.put(AppStrings.VoiceMailInput.voicemail_sms_alert, AppStrings.VoiceMailInput.voicemail_sms_alert);
                job.put(AppStrings.VoiceMailInput.diversion_timer, AppStrings.VoiceMailInput.diversion_timer);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(VoiceMailsActivity.this);
        }
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.unavailable_message_ll:

                /*initiating call for unavailable message*/
                coreContext.unavailabel_message(AppStrings.Constants.unavailabel_message);
                //LinphoneManager.getInstance().newOutgoingCall(AppStrings.Constants.unavailabel_message, "Unavailable" + AppStrings.Constants.unavailabel_message);
                finish();
                break;

            case R.id.busy_message_ll:

                /*initiating call for busy message*/
                coreContext.busy_message(AppStrings.Constants.busy_message);
              // LinphoneManager.getInstance().newOutgoingCall(AppStrings.Constants.busy_message, "Unavailable" + AppStrings.Constants.busy_message);
                finish();

                break;
            case R.id.turn_off_vm_ll:

                turn_off_vm_cb.performClick();

                break;
            case R.id.prompt_for_mail_box_ll:

                prompt_for_mail_box_cb.performClick();

                break;
            case R.id.email_vm_ll:

                email_vm_cb.performClick();

                break;

            case R.id.back_iv:


                /*updating voicemail data here*/

                updateVoiceMailApiCall();

                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        if (URL.equals(RestApis.get_voip_params)) {
            voicemailResponse(response, RestApis.get_voip_params);
        } else if (URL.equals(RestApis.set_voip_params)) {
            voicemailResponse(response, RestApis.set_voip_params);
        }

    }


    public void voicemailResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {


                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));


                    turnoff_vm_status = job.getString(AppStrings.VoiceMailInput.voicemail_disable);
                    prompt_for_mail_box_status = job.getString(AppStrings.VoiceMailInput.voicemail_mailboxprompt);
                    email_vm_status = job.getString(AppStrings.VoiceMailInput.voicemail_emailonly);


                    voice_mail_pin_et.setText(job.getString(AppStrings.VoiceMailInput.voicemail_pin));
                    send_copy_et.setText(job.getString(AppStrings.VoiceMailInput.voicemail_emailcopy));
                    call_div_timer_et.setText(job.getString(AppStrings.VoiceMailInput.diversion_timer));
                    sms_alert_et.setText(job.getString(AppStrings.VoiceMailInput.voicemail_sms_alert));

                    checkingCheckboxesStatus(turnoff_vm_status, prompt_for_mail_box_status, email_vm_status);




                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);
                    AppMethods.hideSoftKeyboard(this);
                    finish();
                }

            } else {
                AppMethods.showToast(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public void checkingCheckboxesStatus(String turnoff_vm_status, String prompt_for_mail_box_status, String email_vm_status) {



        if (turnoff_vm_status.equals(AppStrings.Constants.on)) {
            turn_off_vm_cb.setChecked(true);
        } else {
            turn_off_vm_cb.setChecked(false);
        }
        if (prompt_for_mail_box_status.equals(AppStrings.Constants.on)) {
            prompt_for_mail_box_cb.setChecked(true);
        } else {
            prompt_for_mail_box_cb.setChecked(false);
        }
        if (email_vm_status.equals(AppStrings.Constants.on)) {
            email_vm_cb.setChecked(true);
        } else {
            email_vm_cb.setChecked(false);
        }

    }


}
