package org.linphone.bluereach;

import android.app.TimePickerDialog;
import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.bluereach.handlers.TimeWorkHourAdapter;
import org.linphone.bluereach.models.TimeWorkHourModel;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class TimeScheduleActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {
    private static final String TAG = "HomeActivity";
    RecyclerView time_workhour_rv;
    TimeWorkHourAdapter workHourAdapter;
    ArrayList<TimeWorkHourModel> workSchArrayList;
    LinearLayoutManager manager;
    SessionManager sessionManager;

    ImageView back_iv;
    TextView title_tv;
    String[] day_array;
    int selected_pos, type;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_timeschedule);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        initUI();

    }

    public void addData() {
        day_array = getResources().getStringArray(R.array.days_array);

        for (int i = 0; i < day_array.length; i++) {
            TimeWorkHourModel model = new TimeWorkHourModel();
            model.setDayName(day_array[i]);
            switch (i) {
                case 0:
                    model.setDaytype(2);
                    model.setTimeFrom("09:00");
                    model.setTimeTo("17:00");
                    break;
                case 1:
                    model.setDaytype(2);
                    model.setTimeFrom("09:00");
                    model.setTimeTo("17:00");
                    break;
                case 2:
                    model.setDaytype(2);
                    model.setTimeFrom("09:00");
                    model.setTimeTo("17:00");
                    break;
                case 3:
                    model.setDaytype(2);
                    model.setTimeFrom("09:00");
                    model.setTimeTo("17:00");
                    break;
                case 4:
                    model.setDaytype(2);
                    model.setTimeFrom("09:00");
                    model.setTimeTo("17:00");
                    break;
                case 5:
                    model.setDaytype(2);
                    model.setTimeFrom("09:00");
                    model.setTimeTo("17:00");
                    break;
                case 6:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 7:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;


                case 8:
                    model.setDaytype(2);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 9:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 10:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 11:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 12:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 13:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 14:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 15:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;
                case 16:
                    model.setDaytype(2);
                    model.setTimeFrom("08:00");
                    model.setTimeTo("22:00");
                    break;


                case 17:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 18:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 19:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 20:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 21:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 22:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 23:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
                case 24:
                    model.setDaytype(0);
                    model.setTimeFrom("");
                    model.setTimeTo("");
                    break;
            }


            model.setDayStatus(true);


            workSchArrayList.add(model);

        }
        workHourAdapter.notifyDataSetChanged();


    }

    public void initUI() {

        sessionManager = new SessionManager(this);
        workSchArrayList = new ArrayList<>();
        time_workhour_rv = (RecyclerView) findViewById(R.id.time_workhour_rv);
        workHourAdapter = new TimeWorkHourAdapter(this, workSchArrayList);
        manager = new LinearLayoutManager(this);
        time_workhour_rv.setLayoutManager(manager);
        time_workhour_rv.setAdapter(workHourAdapter);
        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);
        title_tv.setText(getResources().getString(R.string.time_schedules));
        back_iv.setOnClickListener(this);
        /*adding data for the first time*/
        addData();
       /*performing gettimeschedule acion*/
        timeScheduleApi(RestApis.get_voip_params, getJson());

    }

    public void updateDayStatus(int pos, boolean status, int type) {
        if (type == 1) {
            type = 0;
        } else {
            type = 1;
        }
        workSchArrayList.get(pos).setDaytype(type);


        for (int i = 0; i < workSchArrayList.size(); i++) {
            Log.e(TAG, "updateDayStatus:getDaytype is :  " + workSchArrayList.get(i).getDaytype());
            Log.e(TAG, "updateDayStatus:iiii  is :  " + i);
        }


    }

    public void setFromTime(int pos) {
        openTimePickerDialog(false, pos, 0);

    }

    public void setToTime(int pos) {
        openTimePickerDialog(false, pos, 1);
    }


    private void openTimePickerDialog(boolean is24r, final int pos, final int typed) {

        selected_pos = pos;
        type = typed;
        Calendar calendar = Calendar.getInstance();


        TimePickerDialog timePickerDialog = new TimePickerDialog(this,
                onTimeSetListener, calendar.get(Calendar.HOUR_OF_DAY),
                calendar.get(Calendar.MINUTE), is24r);
        timePickerDialog.show();


    }

    TimePickerDialog.OnTimeSetListener onTimeSetListener = new TimePickerDialog.OnTimeSetListener() {

        @Override
        public void onTimeSet(TimePicker view, int hourOfDay, int minute) {


            String AM_PM;
            if (hourOfDay < 12) {
                AM_PM = "AM";
            } else {
                AM_PM = "PM";
            }
            Calendar calNow = Calendar.getInstance();
            Calendar calSet = (Calendar) calNow.clone();
            calSet.set(Calendar.HOUR_OF_DAY, hourOfDay);
            calSet.set(Calendar.MINUTE, minute);
            calSet.set(Calendar.SECOND, 0);
            calSet.set(Calendar.MILLISECOND, 0);

            if (calSet.compareTo(calNow) <= 0) {
                // Today Set time passed, count to tomorrow
                calSet.add(Calendar.DATE, 1);
            }
            try {
                SimpleDateFormat _24HourSDF = new SimpleDateFormat("HH:mm");
//                SimpleDateFormat _12HourSDF = new SimpleDateFormat("hh:mm a");
//                SimpleDateFormat _12HourSDF = new SimpleDateFormat("hh:mm a");
                SimpleDateFormat _12HourSDF = new SimpleDateFormat("hh:mm");
                Date _24HourDt = _24HourSDF.parse(hourOfDay + ":" + minute);
                System.out.println(_24HourDt);
                System.out.println(_12HourSDF.format(_24HourDt));



                if (type == 0) {
                    workSchArrayList.get(selected_pos).setTimeFrom(_24HourSDF.format(_24HourDt));
                } else {
                    if (type == 1) {
                        if (dateCompare(workSchArrayList.get(selected_pos).getTimeFrom(), _24HourSDF.format(_24HourDt)))
                            workSchArrayList.get(selected_pos).setTimeTo(_24HourSDF.format(_24HourDt));
                        else
                            Toast.makeText(TimeScheduleActivity.this, "End time should less tha Start time", Toast.LENGTH_SHORT).show();
                    }
                }
                workHourAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }


        }
    };


    public boolean dateCompare(String time_from, String time_to) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("hh:mm");
            Date time_from_d = sdf.parse(time_from);
            Date time_to_d = sdf.parse(time_to);
            if (time_from_d.compareTo(time_to_d) > 0) {


                return false;
            } else if (time_from_d.compareTo(time_to_d) < 0) {
                return true;

            } else if (time_from_d.compareTo(time_to_d) == 0) {

                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String workhoursStart(int pos, String type) {
        String days[] = getResources().getStringArray(R.array.days_array);
        return type + days[pos].toLowerCase() + timeSch.start;
    }

    public String workhoursEnd(int pos, String type) {
        String days[] = getResources().getStringArray(R.array.days_array);
        return type + days[pos].toLowerCase() + timeSch.end;
    }

    public String workhours(int pos, String type) {
        String days[] = getResources().getStringArray(R.array.days_array);
        return type + days[pos].toLowerCase();
    }


    interface timeSch {

        String workhours = "workhours_";
        String available = "available_";
        String userdefined = "userdefined_";
        String start = "_start";
        String end = "_end";


    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.back_iv:

                /*updating time schedule data*/
                timeScheduleApi(RestApis.set_voip_params, updateJson());

                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {

        timeScheduleResponse(response, URL);

    }

    public JSONObject updateJson() {


        JSONObject monJsonObject = new JSONObject();
        try {

            for (int i = 1; i < 8; i++) {
                monJsonObject.put(workhours(i, timeSch.workhours), workSchArrayList.get(i).getDaytype());
                monJsonObject.put(workhoursStart(i, timeSch.workhours), workSchArrayList.get(i).getTimeFrom());
                monJsonObject.put(workhoursEnd(i, timeSch.workhours), workSchArrayList.get(i).getTimeTo());
            }

            for (int i = 9; i < 16; i++) {
                monJsonObject.put(workhours(i, timeSch.available), workSchArrayList.get(i).getDaytype());
                monJsonObject.put(workhoursStart(i, timeSch.available), workSchArrayList.get(i).getTimeFrom());
                monJsonObject.put(workhoursEnd(i, timeSch.available), workSchArrayList.get(i).getTimeTo());
            }

            for (int i = 17; i < 24; i++) {
                monJsonObject.put(workhours(i, timeSch.userdefined), workSchArrayList.get(i).getDaytype());
                monJsonObject.put(workhoursStart(i, timeSch.userdefined), workSchArrayList.get(i).getTimeFrom());
                monJsonObject.put(workhoursEnd(i, timeSch.userdefined), workSchArrayList.get(i).getTimeTo());
            }


        } catch (Exception e) {
            e.printStackTrace();
        }
        return monJsonObject;


    }

    public JSONObject getJson() {
        JSONObject monJsonObject = new JSONObject();
        try {

            for (int i = 1; i < 8; i++) {
                monJsonObject.put(workhours(i, timeSch.workhours), workhours(i, timeSch.workhours));
                monJsonObject.put(workhoursStart(i, timeSch.workhours), workhoursStart(i, timeSch.workhours));
                monJsonObject.put(workhoursEnd(i, timeSch.workhours), workhoursEnd(i, timeSch.workhours));
            }

            for (int i = 9; i < 16; i++) {
                monJsonObject.put(workhours(i, timeSch.available), workhours(i, timeSch.available));
                monJsonObject.put(workhoursStart(i, timeSch.available), workhoursStart(i, timeSch.available));
                monJsonObject.put(workhoursEnd(i, timeSch.available), workhoursEnd(i, timeSch.available));
            }

            for (int i = 17; i < 24; i++) {
                monJsonObject.put(workhours(i, timeSch.userdefined), workhours(i, timeSch.userdefined));
                monJsonObject.put(workhoursStart(i, timeSch.userdefined), workhoursStart(i, timeSch.userdefined));
                monJsonObject.put(workhoursEnd(i, timeSch.userdefined), workhoursEnd(i, timeSch.userdefined));
            }


        } catch (Exception e) {
            e.printStackTrace();
        }
        return monJsonObject;


    }

    public void timeScheduleApi(String action, JSONObject job) {

        if (AppMethods.isConnectingToInternet(TimeScheduleActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));


                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, action, jo);
        } else {
            AppMethods.alertForNoInternet(TimeScheduleActivity.this);
        }
    }

    public void timeScheduleResponse(String response, String url) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            String Message = jsonObject.getString(AppStrings.OutputParams.Message);
            String Status = jsonObject.getString(AppStrings.OutputParams.Status);
            if (Status.equals(AppStrings.OutputParams.Success)) {

                if (url.equals(RestApis.get_voip_params)) {

                    JSONObject params = jsonObject.getJSONObject(AppStrings.OutputParams.params);

                    String workhours_monday_start = params.getString(AppStrings.TimeSchedule.workhours_monday_start);
                    String workhours_monday_end = params.getString(AppStrings.TimeSchedule.workhours_monday_end);


                    TimeWorkHourModel model1 = new TimeWorkHourModel();
                    model1.setDayStatus(true);
                    model1.setDayName(day_array[1]);


                    int workhours_monday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_monday));


                    if (workhours_monday == 2) {
                        model1.setDaytype(1);
                    } else if (workhours_monday == 1) {
                        model1.setDaytype(workhours_monday);
                    } else if (workhours_monday == 0) {
                        model1.setDaytype(workhours_monday);
                    }


                    if (workhours_monday_start.equals("00:00")) {
                        model1.setTimeFrom("09:20");
                    } else {
                        model1.setTimeFrom(workhours_monday_start);
                    }
                    if (workhours_monday_end.equals("00:00")) {
                        model1.setTimeTo("17:00");
                    } else {
                        model1.setTimeTo(workhours_monday_end);
                    }


                    workSchArrayList.set(1, model1);

                    int workhours_tuesday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_tuesday));
                    String workhours_tuesday_start = params.getString(AppStrings.TimeSchedule.workhours_tuesday_start);
                    String workhours_tuesday_end = params.getString(AppStrings.TimeSchedule.workhours_tuesday_end);

                    TimeWorkHourModel model2 = new TimeWorkHourModel();
                    model2.setDayStatus(true);
                    model2.setDayName(day_array[2]);


                    if (workhours_tuesday == 2) {
                        model2.setDaytype(1);
                    } else if (workhours_tuesday == 1) {
                        model2.setDaytype(workhours_tuesday);
                    } else if (workhours_tuesday == 0) {
                        model2.setDaytype(workhours_tuesday);
                    }

                    if (workhours_tuesday_start.equals("00:00")) {
                        model2.setTimeFrom("09:20");
                    } else {
                        model2.setTimeFrom(workhours_tuesday_start);
                    }
                    if (workhours_tuesday_end.equals("00:00")) {
                        model2.setTimeTo("17:00");
                    } else {
                        model2.setTimeTo(workhours_tuesday_end);
                    }


                    workSchArrayList.set(2, model2);

                    int workhours_wednesday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_wednesday));
                    String workhours_wednesday_start = params.getString(AppStrings.TimeSchedule.workhours_wednesday_start);
                    String workhours_wednesday_end = params.getString(AppStrings.TimeSchedule.workhours_wednesday_end);

                    TimeWorkHourModel model3 = new TimeWorkHourModel();
                    model3.setDayStatus(true);
                    model3.setDayName(day_array[3]);


                    if (workhours_wednesday == 2) {
                        model3.setDaytype(1);
                    } else if (workhours_wednesday == 1) {
                        model3.setDaytype(workhours_wednesday);
                    } else if (workhours_wednesday == 0) {
                        model3.setDaytype(workhours_wednesday);
                    }


                    if (workhours_wednesday_start.equals("00:00")) {
                        model3.setTimeFrom("09:20");
                    } else {
                        model3.setTimeFrom(workhours_wednesday_start);
                    }
                    if (workhours_wednesday_end.equals("00:00")) {
                        model3.setTimeTo("17:00");
                    } else {
                        model3.setTimeTo(workhours_wednesday_end);
                    }


                    workSchArrayList.set(3, model3);

                    int workhours_thursday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_thursday));
                    String workhours_thursday_start = params.getString(AppStrings.TimeSchedule.workhours_thursday_start);
                    String workhours_thursday_end = params.getString(AppStrings.TimeSchedule.workhours_thursday_end);

                    TimeWorkHourModel model4 = new TimeWorkHourModel();
                    model4.setDayStatus(true);
                    model4.setDayName(day_array[4]);


                    if (workhours_thursday == 2) {
                        model4.setDaytype(1);

                    } else if (workhours_thursday == 1) {
                        model4.setDaytype(workhours_thursday);

                    } else if (workhours_thursday == 0) {
                        model4.setDaytype(workhours_thursday);

                    }


                    if (workhours_thursday_start.equals("00:00")) {
                        model4.setTimeFrom("09:20");
                    } else {
                        model4.setTimeFrom(workhours_thursday_start);
                    }
                    if (workhours_thursday_end.equals("00:00")) {
                        model4.setTimeTo("17:00");
                    } else {
                        model4.setTimeTo(workhours_thursday_end);
                    }


                    workSchArrayList.set(4, model4);

                    int workhours_friday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_friday));
                    String workhours_friday_start = params.getString(AppStrings.TimeSchedule.workhours_friday_start);
                    String workhours_friday_end = params.getString(AppStrings.TimeSchedule.workhours_friday_end);

                    TimeWorkHourModel model5 = new TimeWorkHourModel();
                    model5.setDayStatus(true);
                    model5.setDayName(day_array[5]);


                    if (workhours_friday == 2) {
                        model5.setDaytype(1);
                    } else if (workhours_friday == 1) {
                        model5.setDaytype(workhours_friday);
                    } else if (workhours_friday == 0) {
                        model5.setDaytype(workhours_friday);
                    }


                    if (workhours_friday_start.equals("00:00")) {
                        model5.setTimeFrom("09:20");
                    } else {
                        model5.setTimeFrom(workhours_friday_start);
                    }
                    if (workhours_friday_end.equals("00:00")) {
                        model5.setTimeTo("17:00");
                    } else {
                        model5.setTimeTo(workhours_friday_end);
                    }


                    workSchArrayList.set(5, model5);

                    int workhours_saturday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_saturday));
                    String workhours_saturday_start = params.getString(AppStrings.TimeSchedule.workhours_saturday_start);
                    String workhours_saturday_end = params.getString(AppStrings.TimeSchedule.workhours_saturday_end);

                    TimeWorkHourModel model6 = new TimeWorkHourModel();
                    model6.setDayStatus(true);
                    model6.setDayName(day_array[6]);
                    model6.setDaytype(workhours_saturday);


                    if (workhours_saturday_start.equals("00:00")) {
                        model6.setTimeFrom("09:20");
                    } else {
                        model6.setTimeFrom(workhours_saturday_start);
                    }
                    if (workhours_saturday_end.equals("00:00")) {
                        model6.setTimeTo("17:00");
                    } else {
                        model6.setTimeTo(workhours_saturday_end);
                    }


                    workSchArrayList.set(6, model6);

                    int workhours_sunday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.workhours_sunday));
                    String workhours_sunday_start = params.getString(AppStrings.TimeSchedule.workhours_sunday_start);
                    String workhours_sunday_end = params.getString(AppStrings.TimeSchedule.workhours_sunday_end);

                    TimeWorkHourModel model7 = new TimeWorkHourModel();
                    model7.setDayStatus(true);
                    model7.setDayName(day_array[7]);
                    model7.setDaytype(workhours_sunday);


                    if (workhours_sunday_start.equals("00:00")) {
                        model7.setTimeFrom("");
                    } else {
                        model7.setTimeFrom(workhours_sunday_start);
                    }
                    if (workhours_sunday_end.equals("00:00")) {
                        model7.setTimeTo("");
                    } else {
                        model7.setTimeTo(workhours_sunday_end);
                    }


                    workSchArrayList.set(7, model7);






                      /*available hours*/

                    int available_monday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_monday));
                    String available_monday_start = params.getString(AppStrings.TimeSchedule.available_monday_start);
                    String available_monday_end = params.getString(AppStrings.TimeSchedule.available_monday_end);

                    TimeWorkHourModel model8 = new TimeWorkHourModel();
                    model8.setDayStatus(true);


                    if (available_monday == 2) {
                        model8.setDaytype(1);
                    } else if (available_monday == 1) {
                        model8.setDaytype(available_monday);
                    } else if (available_monday == 0) {
                        model8.setDaytype(available_monday);
                    }


                    if (available_monday_start.equals("00:00")) {
                        model8.setTimeFrom("8:00");
                    } else {
                        model8.setTimeFrom(available_monday_start);
                    }
                    if (available_monday_end.equals("00:00")) {
                        model8.setTimeTo("22:00");
                    } else {
                        model8.setTimeTo(available_monday_end);
                    }

                    model8.setDayName(day_array[9]);
                    workSchArrayList.set(9, model8);


                    int available_tuesday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_tuesday));
                    String available_tuesday_start = params.getString(AppStrings.TimeSchedule.available_tuesday_start);
                    String available_tuesday_end = params.getString(AppStrings.TimeSchedule.available_tuesday_end);

                    TimeWorkHourModel model9 = new TimeWorkHourModel();
                    model9.setDayStatus(true);


                    if (available_tuesday == 2) {
                        model9.setDaytype(1);
                    } else if (available_tuesday == 1) {
                        model9.setDaytype(available_tuesday);
                    } else if (available_tuesday == 0) {
                        model9.setDaytype(available_tuesday);
                    }
                    if (available_tuesday_start.equals("00:00")) {
                        model9.setTimeFrom("08:20");
                    } else {
                        model9.setTimeFrom(available_tuesday_start);
                    }
                    if (available_tuesday_end.equals("00:00")) {
                        model9.setTimeTo("22:00");
                    } else {
                        model9.setTimeTo(available_tuesday_end);
                    }


                    model9.setDayName(day_array[10]);
                    workSchArrayList.set(10, model9);

                    int available_wednesday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_wednesday));
                    String available_wednesday_start = params.getString(AppStrings.TimeSchedule.available_wednesday_start);
                    String available_wednesday_end = params.getString(AppStrings.TimeSchedule.available_wednesday_end);

                    TimeWorkHourModel model10 = new TimeWorkHourModel();
                    model10.setDayStatus(true);
                    model10.setDayName(day_array[11]);

                    if (available_wednesday == 2) {
                        model10.setDaytype(1);
                    } else if (available_wednesday == 1) {
                        model10.setDaytype(available_wednesday);
                    } else if (available_wednesday == 0) {
                        model10.setDaytype(available_wednesday);
                    }

                    if (available_wednesday_start.equals("00:00")) {
                        model10.setTimeFrom("08:20");
                    } else {
                        model10.setTimeFrom(available_wednesday_start);
                    }
                    if (available_wednesday_end.equals("00:00")) {
                        model10.setTimeTo("22:00");
                    } else {
                        model10.setTimeTo(available_wednesday_end);
                    }

                    workSchArrayList.set(11, model10);

                    int available_thursday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_thursday));
                    String available_thursday_start = params.getString(AppStrings.TimeSchedule.available_thursday_start);
                    String available_thursday_end = params.getString(AppStrings.TimeSchedule.available_thursday_end);

                    TimeWorkHourModel model11 = new TimeWorkHourModel();
                    model11.setDayStatus(true);
                    model11.setDayName(day_array[12]);


                    if (available_thursday == 2) {
                        model11.setDaytype(1);
                    } else if (available_thursday == 1) {
                        model11.setDaytype(available_thursday);
                    } else if (available_thursday == 0) {
                        model11.setDaytype(available_thursday);
                    }

                    if (available_thursday_start.equals("00:00")) {
                        model11.setTimeFrom("08:20");
                    } else {
                        model11.setTimeFrom(available_thursday_start);
                    }
                    if (available_thursday_end.equals("00:00")) {
                        model11.setTimeTo("22:00");
                    } else {
                        model11.setTimeTo(available_thursday_end);
                    }

                    workSchArrayList.set(12, model11);

                    int available_friday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_friday));
                    String available_friday_start = params.getString(AppStrings.TimeSchedule.available_friday_start);
                    String available_friday_end = params.getString(AppStrings.TimeSchedule.available_friday_end);

                    TimeWorkHourModel model12 = new TimeWorkHourModel();
                    model12.setDayStatus(true);
                    model12.setDayName(day_array[13]);


                    if (available_friday == 2) {
                        model12.setDaytype(1);
                    } else if (available_friday == 1) {
                        model12.setDaytype(available_friday);
                    } else if (available_friday == 0) {
                        model12.setDaytype(available_friday);
                    }


                    if (available_friday_start.equals("00:00")) {
                        model12.setTimeFrom("08:20");
                    } else {
                        model12.setTimeFrom(available_friday_start);
                    }
                    if (available_friday_end.equals("00:00")) {
                        model12.setTimeTo("22:00");
                    } else {
                        model12.setTimeTo(available_friday_end);
                    }


                    workSchArrayList.set(13, model12);

                    int available_saturday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_saturday));
                    String available_saturday_start = params.getString(AppStrings.TimeSchedule.available_saturday_start);
                    String available_saturday_end = params.getString(AppStrings.TimeSchedule.available_saturday_end);

                    TimeWorkHourModel model13 = new TimeWorkHourModel();
                    model13.setDayStatus(true);
                    model13.setDayName(day_array[14]);


                    if (available_saturday == 2) {
                        model13.setDaytype(1);
                    } else if (available_saturday == 1) {
                        model13.setDaytype(available_saturday);
                    } else if (available_saturday == 0) {
                        model13.setDaytype(available_saturday);
                    }

                    if (available_saturday_start.equals("00:00")) {
                        model13.setTimeFrom("08:20");
                    } else {
                        model13.setTimeFrom(available_saturday_start);
                    }
                    if (available_saturday_end.equals("00:00")) {
                        model13.setTimeTo("22:00");
                    } else {
                        model13.setTimeTo(available_saturday_end);
                    }


                    workSchArrayList.set(14, model13);

                    int available_sunday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.available_sunday));
                    String available_sunday_start = params.getString(AppStrings.TimeSchedule.available_sunday_start);
                    String available_sunday_end = params.getString(AppStrings.TimeSchedule.available_sunday_end);

                    TimeWorkHourModel model14 = new TimeWorkHourModel();
                    model14.setDayStatus(true);
                    model14.setDayName(day_array[15]);


                    if (available_sunday == 2) {
                        model14.setDaytype(1);
                    } else if (available_sunday == 1) {
                        model14.setDaytype(available_sunday);
                    } else if (available_sunday == 0) {
                        model14.setDaytype(available_sunday);
                    }

                    if (available_sunday_start.equals("00:00") || available_sunday_start.equals("")) {
                        model14.setTimeFrom("08:20");
                    } else {
                        model14.setTimeFrom(available_sunday_start);
                    }
                    if (available_sunday_end.equals("00:00") || available_sunday_end.equals("")) {
                        model14.setTimeTo("22:00");
                    } else {
                        model14.setTimeTo(available_sunday_end);
                    }


                    workSchArrayList.set(15, model14);


/*user Defined*/


                    int userdefined_monday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_monday));
                    String userdefined_monday_start = params.getString(AppStrings.TimeSchedule.userdefined_monday_start);
                    String userdefined_monday_end = params.getString(AppStrings.TimeSchedule.userdefined_monday_end);

                    TimeWorkHourModel model15 = new TimeWorkHourModel();
                    model15.setDayStatus(true);
                    model15.setDayName(day_array[17]);
                    model15.setDaytype(userdefined_monday);


                    if (userdefined_monday_start.equals("00:00")) {
                        model15.setTimeFrom("");
                    } else {
                        model15.setTimeFrom(userdefined_monday_start);
                    }
                    if (userdefined_monday_end.equals("00:00")) {
                        model15.setTimeTo("");
                    } else {
                        model15.setTimeTo(userdefined_monday_end);
                    }


                    workSchArrayList.set(17, model15);

                    int userdefined_tuesday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_tuesday));
                    String userdefined_tuesday_start = params.getString(AppStrings.TimeSchedule.userdefined_tuesday_start);
                    String userdefined_tuesday_end = params.getString(AppStrings.TimeSchedule.userdefined_tuesday_end);

                    TimeWorkHourModel model16 = new TimeWorkHourModel();
                    model16.setDayStatus(true);
                    model16.setDayName(day_array[18]);
                    model16.setDaytype(userdefined_tuesday);


                    if (userdefined_tuesday_start.equals("00:00")) {
                        model16.setTimeFrom("");
                    } else {
                        model16.setTimeFrom(userdefined_tuesday_start);
                    }
                    if (userdefined_tuesday_end.equals("00:00")) {
                        model16.setTimeTo("");
                    } else {
                        model16.setTimeTo(userdefined_tuesday_end);
                    }


                    workSchArrayList.set(18, model16);

                    int userdefined_wednesday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_wednesday));
                    String userdefined_wednesday_start = params.getString(AppStrings.TimeSchedule.userdefined_wednesday_start);
                    String userdefined_wednesday_end = params.getString(AppStrings.TimeSchedule.userdefined_wednesday_end);

                    TimeWorkHourModel model17 = new TimeWorkHourModel();
                    model17.setDayStatus(true);
                    model17.setDayName(day_array[19]);
                    model17.setDaytype(userdefined_wednesday);


                    if (userdefined_wednesday_start.equals("00:00")) {
                        model17.setTimeFrom("");
                    } else {
                        model17.setTimeFrom(userdefined_wednesday_start);
                    }
                    if (userdefined_wednesday_end.equals("00:00")) {
                        model17.setTimeTo("");
                    } else {
                        model17.setTimeTo(userdefined_wednesday_end);
                    }


                    workSchArrayList.set(19, model17);


                    int userdefined_thursday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_thursday));
                    String userdefined_thursday_start = params.getString(AppStrings.TimeSchedule.userdefined_thursday_start);
                    String userdefined_thursday_end = params.getString(AppStrings.TimeSchedule.userdefined_thursday_end);

                    TimeWorkHourModel model18 = new TimeWorkHourModel();
                    model18.setDayStatus(true);
                    model18.setDayName(day_array[20]);
                    model18.setDaytype(userdefined_thursday);


                    if (userdefined_thursday_start.equals("00:00")) {
                        model18.setTimeFrom("");
                    } else {
                        model18.setTimeFrom(userdefined_thursday_start);
                    }
                    if (userdefined_thursday_end.equals("00:00")) {
                        model18.setTimeTo("");
                    } else {
                        model18.setTimeTo(userdefined_thursday_end);
                    }


                    workSchArrayList.set(20, model18);

                    int userdefined_friday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_friday));
                    String userdefined_friday_start = params.getString(AppStrings.TimeSchedule.userdefined_friday_start);
                    String userdefined_friday_end = params.getString(AppStrings.TimeSchedule.userdefined_friday_end);

                    TimeWorkHourModel model19 = new TimeWorkHourModel();

                    model19.setDayName(day_array[21]);
                    model19.setDayStatus(true);
                    model19.setDaytype(userdefined_friday);


                    if (userdefined_friday_start.equals("00:00")) {
                        model19.setTimeFrom("");
                    } else {
                        model19.setTimeFrom(userdefined_friday_start);
                    }
                    if (userdefined_friday_end.equals("00:00")) {
                        model19.setTimeTo("");
                    } else {
                        model19.setTimeTo(userdefined_friday_end);
                    }


                    workSchArrayList.set(21, model19);

                    int userdefined_saturday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_saturday));
                    String userdefined_saturday_start = params.getString(AppStrings.TimeSchedule.userdefined_saturday_start);
                    String userdefined_saturday_end = params.getString(AppStrings.TimeSchedule.userdefined_saturday_end);

                    TimeWorkHourModel model20 = new TimeWorkHourModel();
                    model20.setDayStatus(true);
                    model20.setDayName(day_array[22]);
                    model20.setDaytype(userdefined_saturday);


                    if (userdefined_saturday_start.equals("00:00")) {
                        model20.setTimeFrom("");
                    } else {
                        model20.setTimeFrom(userdefined_saturday_start);
                    }
                    if (userdefined_saturday_end.equals("00:00")) {
                        model20.setTimeTo("");
                    } else {
                        model20.setTimeTo(userdefined_saturday_end);
                    }
                    workSchArrayList.set(22, model20);

                    int userdefined_sunday = Integer.parseInt(params.getString(AppStrings.TimeSchedule.userdefined_sunday));
                    String userdefined_sunday_start = params.getString(AppStrings.TimeSchedule.userdefined_sunday_start);
                    String userdefined_sunday_end = params.getString(AppStrings.TimeSchedule.userdefined_sunday_end);


                    TimeWorkHourModel model21 = new TimeWorkHourModel();
                    model21.setDayName(day_array[23]);
                    model21.setDayStatus(true);
                    model21.setDaytype(userdefined_sunday);

                    if (userdefined_sunday_start.equals("00:00")) {
                        model21.setTimeFrom("");
                    } else {
                        model21.setTimeFrom(userdefined_sunday_start);
                    }
                    if (userdefined_sunday_end.equals("00:00")) {
                        model21.setTimeTo("");
                    } else {
                        model21.setTimeTo(userdefined_sunday_start);
                    }
                    workSchArrayList.set(23, model21);

                    workHourAdapter.notifyDataSetChanged();


                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);

                    finish();
                }

            } else {
//                AppMethods.alertWithOk(this, Message);
                AppMethods.showToast(this, Message);
            }


        } catch (Exception e) {
            e.printStackTrace();
        }

    }


}
