package org.linphone.bluereach;

import android.os.Bundle;

import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatEditText;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

public class SpeedDialActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {

    AppCompatEditText digi2_et, digi3_et, digi4_et, digi5_et, digi6_et, digi7_et, digi8_et, digi9_et;
    private static final String TAG = "SpeedDialActivity";
    SessionManager sessionManager;
    ImageView back_iv;
    TextView title_tv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_speed_dial);
        init();
    }

    public void init() {

        sessionManager = new SessionManager(this);
        title_tv = (TextView) findViewById(R.id.title_tv);
        back_iv = (ImageView) findViewById(R.id.back_iv);
        digi2_et = (AppCompatEditText) findViewById(R.id.digi2_et);
        digi3_et = (AppCompatEditText) findViewById(R.id.digi3_et);
        digi4_et = (AppCompatEditText) findViewById(R.id.digi4_et);
        digi5_et = (AppCompatEditText) findViewById(R.id.digi5_et);
        digi6_et = (AppCompatEditText) findViewById(R.id.digi6_et);
        digi7_et = (AppCompatEditText) findViewById(R.id.digi7_et);
        digi8_et = (AppCompatEditText) findViewById(R.id.digi8_et);
        digi9_et = (AppCompatEditText) findViewById(R.id.digi9_et);
        title_tv.setText(getString(R.string.speed_dial));

        back_iv.setOnClickListener(this);

        getSpeedDialApiCall();
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.back_iv:
                try {
                    AppMethods.hideSoftKeyboard(this);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                updateSpeedDialApiCall();
                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        speedDialResponse(response, URL);
    }


    public void updateSpeedDialApiCall() {

        if (AppMethods.isConnectingToInternet(SpeedDialActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.set_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.SpeedDialInput.speed_dial8_2, digi2_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_3, digi3_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_4, digi4_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_5, digi5_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_6, digi6_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_7, digi7_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_8, digi8_et.getText().toString());
                job.put(AppStrings.SpeedDialInput.speed_dial8_9, digi9_et.getText().toString());

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.set_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(SpeedDialActivity.this);
        }
    }

    public void getSpeedDialApiCall() {

        if (AppMethods.isConnectingToInternet(SpeedDialActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.get_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.SpeedDialInput.speed_dial8_2, AppStrings.SpeedDialInput.speed_dial8_2);
                job.put(AppStrings.SpeedDialInput.speed_dial8_3, AppStrings.SpeedDialInput.speed_dial8_3);
                job.put(AppStrings.SpeedDialInput.speed_dial8_4, AppStrings.SpeedDialInput.speed_dial8_4);
                job.put(AppStrings.SpeedDialInput.speed_dial8_5, AppStrings.SpeedDialInput.speed_dial8_5);
                job.put(AppStrings.SpeedDialInput.speed_dial8_6, AppStrings.SpeedDialInput.speed_dial8_6);
                job.put(AppStrings.SpeedDialInput.speed_dial8_7, AppStrings.SpeedDialInput.speed_dial8_7);
                job.put(AppStrings.SpeedDialInput.speed_dial8_8, AppStrings.SpeedDialInput.speed_dial8_8);
                job.put(AppStrings.SpeedDialInput.speed_dial8_9, AppStrings.SpeedDialInput.speed_dial8_9);
                jo.put(AppStrings.InputParams.params, job);




            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(SpeedDialActivity.this);
        }
    }


    public void speedDialResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {


                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));

                    digi2_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_2));
                    digi3_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_3));
                    digi4_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_4));
                    digi5_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_5));
                    digi6_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_6));
                    digi7_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_7));
                    digi8_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_8));
                    digi9_et.setText(job.getString(AppStrings.SpeedDialInput.speed_dial8_9));


                    setSelectionLength(digi2_et);
                    setSelectionLength(digi3_et);
                    setSelectionLength(digi4_et);
                    setSelectionLength(digi5_et);
                    setSelectionLength(digi6_et);
                    setSelectionLength(digi7_et);
                    setSelectionLength(digi8_et);
                    setSelectionLength(digi9_et);



                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);
                    finish();
                }

            } else {
                AppMethods.showToast(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void setSelectionLength(EditText editText)
    {
        editText.setSelection(editText.getText().length());
    }
}
