package org.linphone.bluereach;

import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toolbar;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.bluereach.handlers.SimulTanAdapter;
import org.linphone.bluereach.models.SimulTanModel;
import org.linphone.bluereach.models.SimultanSpinModel;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimulTaneousActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {


    private static final String TAG = "SimulTaneousActivity";
    RecyclerView simultan_rv;
    LinearLayoutManager manager;
    SimulTanAdapter adapter;
    ArrayList<SimulTanModel> arrayList;
    ArrayList<SimultanSpinModel> spinArrayList;
    SessionManager sessionManager;
    ImageView back_iv;
    TextView title_tv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_simul_taneous);
        androidx.appcompat.widget.Toolbar toolbar = (androidx.appcompat.widget.Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);


        initUI();


    }

    public void settingSpinnersData() {


        spinArrayList.clear();
        List<String> call_forward_names = Arrays.asList(getResources().getStringArray(R.array.call_forward_names));
        List<String> cal_forward_id = Arrays.asList(getResources().getStringArray(R.array.cal_forward_id));

        for (int i = 0; i < call_forward_names.size(); i++) {


            SimultanSpinModel model = new SimultanSpinModel();
            model.setTimeSchdata(call_forward_names.get(i));
            model.setTimeSchid(cal_forward_id.get(i));
            spinArrayList.add(model);
        }
    }

    public void setData() {


        for (int i = 0; i < 10; i++) {
            SimulTanModel model = new SimulTanModel();

            model.setHeaderData(getString(R.string.number) + " " + (i + 1));
            model.setPhoneNo("");
            model.setSecondsDelay("");
            model.setSelectedSpinpos(0);
            model.setSimultanSpinArrayList(spinArrayList);
            model.setEnable_status(0);
            model.setHuntmode_status(0);
            arrayList.add(model);
        }
        adapter.notifyDataSetChanged();
    }

    public void initUI() {
        arrayList = new ArrayList<>();
        spinArrayList = new ArrayList<>();
        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);
        title_tv.setText(getResources().getString(R.string.simulatneous_ring));
        sessionManager = new SessionManager(SimulTaneousActivity.this);
        simultan_rv = (RecyclerView) findViewById(R.id.simultan_rv);
        manager = new LinearLayoutManager(this);
        adapter = new SimulTanAdapter(this, arrayList);
        simultan_rv.setLayoutManager(manager);
        simultan_rv.setAdapter(adapter);
        back_iv.setOnClickListener(this);

        /*adding dropdown data here*/
        settingSpinnersData();

        setData();

        /*performing simultaneous action here*/
        getSimulataneousApiCall();

    }

    public void updateSpin(int pos, int selpos) {


        arrayList.get(pos).setSelectedSpinpos(selpos);
    }

    public void updateHunt(int pos, int st) {


        arrayList.get(pos).setHuntmode_status(st);

    }

    public void updatePhoneNumber(int pos, String data) {
        arrayList.get(pos).setPhoneNo(data);
        for (int i = 0; i < arrayList.size(); i++) {
            Log.e(TAG, "updatePhoneNumber: 1111  is : " + arrayList.get(i).getPhoneNo());
            Log.e(TAG, "updatePhoneNumber: 2222 is : " + arrayList.get(i).getSecondsDelay());
        }

    }

    public void updatePhoneDelay(int pos, String data) {
        arrayList.get(pos).setSecondsDelay(data);


    }

    public void updateEnab(int pos, int st) {
        arrayList.get(pos).setEnable_status(st);
    }

    public JSONObject getJson() {
        JSONObject job_obj = new JSONObject();
        for (int i = 0; i < 10; i++) {


            try {
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.status, AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.status);
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.number, AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.number);
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.waittime, AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.waittime);
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.direct, AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.direct);
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.time, AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.time);


            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return job_obj;
    }

    public JSONObject updateJson() {
        JSONObject job_obj = new JSONObject();
        for (int i = 0; i < 10; i++) {


            try {
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.status, arrayList.get(i).getEnable_status());
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.number, arrayList.get(i).getPhoneNo());
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.waittime, arrayList.get(i).getSecondsDelay());
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.direct, arrayList.get(i).getHuntmode_status());
                job_obj.put(AppStrings.Simulat.simultaneous_ring + String.valueOf(i + 1) + "_" + AppStrings.Simulat.time, arrayList.get(i).getSelectedSpinpos());


            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return job_obj;
    }

    public void ondata(View view) {
        Log.e(TAG, "ondata: " + getJson());
    }

    public void simultaneousRespone(String response, String url) {
        Log.e(TAG, "simultaneousRespone: " + response);
        Log.e(TAG, "simultaneousRespone: " + url);
        try {
            JSONObject jsonObject = new JSONObject(response);
            String Message = jsonObject.getString(AppStrings.OutputParams.Message);
            String Status = jsonObject.getString(AppStrings.OutputParams.Status);

            settingSpinnersData();

            if (Status.equals(AppStrings.OutputParams.Success)) {

                arrayList.clear();

                if (url.equals(RestApis.get_voip_params)) {

                    JSONObject params = jsonObject.getJSONObject(AppStrings.OutputParams.params);
                    String simultaneous_ring1_number = params.getString(AppStrings.Simulataneous.simultaneous_ring1_number);
                    String simultaneous_ring1_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring1_waittime);

                    SimulTanModel model1 = new SimulTanModel();
                    model1.setHeaderData(getString(R.string.number) + " 1");


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring1_status).equals("")) {
                        model1.setEnable_status(0);
                    } else {
                        int simultaneous_ring1_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring1_status));

                        model1.setEnable_status(simultaneous_ring1_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring1_direct).equals("")) {
                        model1.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring1_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring1_direct));

                        model1.setHuntmode_status(simultaneous_ring1_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring1_time).equals("")) {
                        model1.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring1_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring1_time));

                        model1.setSelectedSpinpos(simultaneous_ring1_time);
                    }

                    model1.setPhoneNo(simultaneous_ring1_number);
                    model1.setSimultanSpinArrayList(spinArrayList);
                    model1.setSecondsDelay(simultaneous_ring1_waittime);
                    arrayList.add(model1);


                    String simultaneous_ring2_number = params.getString(AppStrings.Simulataneous.simultaneous_ring2_number);
                    String simultaneous_ring2_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring2_waittime);


                    SimulTanModel model2 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring2_status).equals("")) {
                        model2.setEnable_status(0);
                    } else {
                        int simultaneous_ring2_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring2_status));

                        model2.setEnable_status(simultaneous_ring2_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring2_direct).equals("")) {
                        model2.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring2_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring2_direct));

                        model2.setHuntmode_status(simultaneous_ring2_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring2_time).equals("")) {
                        model2.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring2_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring2_time));

                        model2.setSelectedSpinpos(simultaneous_ring2_time);
                    }


                    model2.setHeaderData(getString(R.string.number) + " 2");
                    model2.setPhoneNo(simultaneous_ring2_number);
                    model2.setSecondsDelay(simultaneous_ring2_waittime);
                    model2.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model2);

                    String simultaneous_ring3_number = params.getString(AppStrings.Simulataneous.simultaneous_ring3_number);
                    String simultaneous_ring3_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring3_waittime);

                    SimulTanModel model3 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring3_status).equals("")) {
                        model3.setEnable_status(0);
                    } else {
                        int simultaneous_ring3_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring3_status));

                        model3.setEnable_status(simultaneous_ring3_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring3_direct).equals("")) {
                        model3.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring3_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring3_direct));

                        model3.setHuntmode_status(simultaneous_ring3_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring3_time).equals("")) {
                        model3.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring3_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring3_time));

                        model3.setSelectedSpinpos(simultaneous_ring3_time);
                    }


                    model3.setHeaderData(getString(R.string.number) + " 3");
                    model3.setPhoneNo(simultaneous_ring3_number);
                    model3.setSecondsDelay(simultaneous_ring3_waittime);
                    model3.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model3);


                    String simultaneous_ring4_number = params.getString(AppStrings.Simulataneous.simultaneous_ring4_number);
                    String simultaneous_ring4_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring4_waittime);


                    SimulTanModel model4 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring4_status).equals("")) {
                        model4.setEnable_status(0);
                    } else {
                        int simultaneous_ring4_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring4_status));

                        model4.setEnable_status(simultaneous_ring4_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring4_direct).equals("")) {
                        model4.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring4_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring4_direct));

                        model4.setHuntmode_status(simultaneous_ring4_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring4_time).equals("")) {
                        model4.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring4_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring4_time));

                        model4.setSelectedSpinpos(simultaneous_ring4_time);
                    }


                    model4.setHeaderData(getString(R.string.number) + " 4");
                    model4.setPhoneNo(simultaneous_ring4_number);
                    model4.setSecondsDelay(simultaneous_ring4_waittime);

                    model4.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model4);

                    String simultaneous_ring5_number = params.getString(AppStrings.Simulataneous.simultaneous_ring5_number);
                    String simultaneous_ring5_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring5_waittime);

                    SimulTanModel model5 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring5_status).equals("")) {
                        model5.setEnable_status(0);
                    } else {
                        int simultaneous_ring5_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring5_status));

                        model5.setEnable_status(simultaneous_ring5_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring5_direct).equals("")) {
                        model5.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring5_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring5_direct));

                        model5.setHuntmode_status(simultaneous_ring5_direct);
                    }


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring5_time).equals("")) {
                        model5.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring5_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring5_time));

                        model5.setSelectedSpinpos(simultaneous_ring5_time);
                    }


                    model5.setHeaderData(getString(R.string.number) + " 5");
                    model5.setPhoneNo(simultaneous_ring5_number);
                    model5.setSecondsDelay(simultaneous_ring5_waittime);
                    model5.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model5);


                    /**********************Adding Extra 5 SimulaTaneous Rings**************/
                    String simultaneous_ring6_number = params.getString(AppStrings.Simulataneous.simultaneous_ring6_number);
                    String simultaneous_ring6_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring6_waittime);


                    SimulTanModel model6 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring6_status).equals("")) {
                        model6.setEnable_status(0);
                    } else {
                        int simultaneous_ring6_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring6_status));

                        model6.setEnable_status(simultaneous_ring6_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring6_direct).equals("")) {
                        model6.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring6_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring6_direct));

                        model6.setHuntmode_status(simultaneous_ring6_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring6_time).equals("")) {
                        model6.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring6_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring6_time));

                        model6.setSelectedSpinpos(simultaneous_ring6_time);
                    }


                    model6.setHeaderData(getString(R.string.number) + " 6");
                    model6.setPhoneNo(simultaneous_ring6_number);
                    model6.setSecondsDelay(simultaneous_ring6_waittime);
                    model6.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model6);


                    String simultaneous_ring7_number = params.getString(AppStrings.Simulataneous.simultaneous_ring7_number);
                    String simultaneous_ring7_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring7_waittime);


                    SimulTanModel model7 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring7_status).equals("")) {
                        model7.setEnable_status(0);
                    } else {
                        int simultaneous_ring7_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring7_status));

                        model7.setEnable_status(simultaneous_ring7_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring7_direct).equals("")) {
                        model7.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring7_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring7_direct));

                        model7.setHuntmode_status(simultaneous_ring7_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring7_time).equals("")) {
                        model7.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring7_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring7_time));

                        model7.setSelectedSpinpos(simultaneous_ring7_time);
                    }


                    model7.setHeaderData(getString(R.string.number) + " 7");
                    model7.setPhoneNo(simultaneous_ring7_number);
                    model7.setSecondsDelay(simultaneous_ring7_waittime);
                    model7.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model7);


                    String simultaneous_ring8_number = params.getString(AppStrings.Simulataneous.simultaneous_ring8_number);
                    String simultaneous_ring8_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring8_waittime);


                    SimulTanModel model8 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring8_status).equals("")) {
                        model8.setEnable_status(0);
                    } else {
                        int simultaneous_ring8_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring8_status));

                        model8.setEnable_status(simultaneous_ring8_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring8_direct).equals("")) {
                        model8.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring8_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring8_direct));

                        model8.setHuntmode_status(simultaneous_ring8_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring8_time).equals("")) {
                        model8.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring8_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring8_time));

                        model8.setSelectedSpinpos(simultaneous_ring8_time);
                    }


                    model8.setHeaderData(getString(R.string.number) + " 8");
                    model8.setPhoneNo(simultaneous_ring8_number);
                    model8.setSecondsDelay(simultaneous_ring8_waittime);
                    model8.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model8);

                    String simultaneous_ring9_number = params.getString(AppStrings.Simulataneous.simultaneous_ring9_number);
                    String simultaneous_ring9_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring9_waittime);


                    SimulTanModel model9 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring9_status).equals("")) {
                        model9.setEnable_status(0);
                    } else {
                        int simultaneous_ring9_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring9_status));

                        model9.setEnable_status(simultaneous_ring9_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring9_direct).equals("")) {
                        model9.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring9_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring9_direct));

                        model9.setHuntmode_status(simultaneous_ring9_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring9_time).equals("")) {
                        model9.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring9_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring9_time));

                        model9.setSelectedSpinpos(simultaneous_ring9_time);
                    }


                    model9.setHeaderData(getString(R.string.number) + " 9");
                    model9.setPhoneNo(simultaneous_ring9_number);
                    model9.setSecondsDelay(simultaneous_ring9_waittime);
                    model9.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model9);

                    String simultaneous_ring10_number = params.getString(AppStrings.Simulataneous.simultaneous_ring10_number);
                    String simultaneous_ring10_waittime = params.getString(AppStrings.Simulataneous.simultaneous_ring10_waittime);


                    SimulTanModel model10 = new SimulTanModel();


                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring10_status).equals("")) {
                        model10.setEnable_status(0);
                    } else {
                        int simultaneous_ring10_status = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring10_status));

                        model10.setEnable_status(simultaneous_ring10_status);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring10_direct).equals("")) {
                        model10.setHuntmode_status(0);
                    } else {
                        int simultaneous_ring10_direct = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring10_direct));

                        model10.setHuntmode_status(simultaneous_ring10_direct);
                    }

                    if (params.getString(AppStrings.Simulataneous.simultaneous_ring10_time).equals("")) {
                        model10.setSelectedSpinpos(0);
                    } else {
                        int simultaneous_ring10_time = Integer.parseInt(params.getString(AppStrings.Simulataneous.simultaneous_ring10_time));

                        model10.setSelectedSpinpos(simultaneous_ring10_time);
                    }


                    model10.setHeaderData(getString(R.string.number) + " 10");
                    model10.setPhoneNo(simultaneous_ring10_number);
                    model10.setSecondsDelay(simultaneous_ring10_waittime);
                    model10.setSimultanSpinArrayList(spinArrayList);
                    arrayList.add(model10);

                    adapter.notifyDataSetChanged();

                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);
                    AppMethods.hideSoftKeyboard(this);
                    finish();
                }


            } else {
//                AppMethods.alertWithOk(this, Message);
                AppMethods.showToast(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    @Override
    public void onClick(View v) {

        switch (v.getId()) {
            case R.id.back_iv:

                /*updating simultaneous data here*/
                updateSimulataneousApiCall();
                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        simultaneousRespone(response, URL);
    }


    public void getSimulataneousApiCall() {

        if (AppMethods.isConnectingToInternet(SimulTaneousActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.get_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));


                jo.put(AppStrings.InputParams.params, getJson());


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(SimulTaneousActivity.this);
        }
    }

    public void updateSimulataneousApiCall() {

        if (AppMethods.isConnectingToInternet(SimulTaneousActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.set_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));


                jo.put(AppStrings.InputParams.params, updateJson());


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.set_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(SimulTaneousActivity.this);
        }
    }

}
