package org.linphone.bluereach;


import static org.linphone.utils.AppMethods.space_filter;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.InputFilter;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.activities.assistant.AssistantActivity;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppIntegers;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;


public class SignupActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {
    private static final String TAG = "SignupActivity";
    EditText signup_name_et, signup_last_name_et, signup_number_et, signup_password_et,
            signup_con_password_et, signup_email_et;
    TextView signup_tv, signup_login_tv;
    Intent intent;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_signup);

        initUI();
    }

    public void initUI() {

        signup_name_et = (EditText) findViewById(R.id.signup_name_et);
        signup_last_name_et = (EditText) findViewById(R.id.signup_last_name_et);
        signup_number_et = (EditText) findViewById(R.id.signup_number_et);
        signup_password_et = (EditText) findViewById(R.id.signup_password_et);
        signup_con_password_et = (EditText) findViewById(R.id.signup_con_password_et);
        signup_email_et = (EditText) findViewById(R.id.signup_email_et);

        signup_password_et.setFilters(new InputFilter[]{space_filter});
        signup_con_password_et.setFilters(new InputFilter[]{space_filter});

        signup_tv = (TextView) findViewById(R.id.signup_tv);
        signup_login_tv = (TextView) findViewById(R.id.signup_login_tv);
        signup_login_tv.setOnClickListener(this);
        signup_tv.setOnClickListener(this);
    }

    public void validation() {
        if (signup_name_et.getText().toString().isEmpty()) {
            AppMethods.alertWithOk(this, getString(R.string.enter_firstname));
        } else if (signup_last_name_et.getText().toString().isEmpty()) {
            AppMethods.alertWithOk(this, getString(R.string.enter_lastname));
        } else if (signup_email_et.getText().toString().isEmpty()) {
            AppMethods.alertWithOk(this, getString(R.string.enter_email));
        } else if (!AppMethods.isValidEmail(signup_email_et.getText().toString())) {
            AppMethods.alertWithOk(this, getString(R.string.enter_valid_email));
        } else if (signup_number_et.getText().toString().isEmpty()) {
            AppMethods.alertWithOk(this, getString(R.string.enter_number));
        } else if (signup_password_et.getText().toString().isEmpty()) {
            AppMethods.alertWithOk(this, getString(R.string.enter_password));
        } else if (signup_password_et.getText().toString().length() < 6) {
            AppMethods.alertWithOk(this, getString(R.string.password_validation));
        } else if (signup_con_password_et.getText().toString().isEmpty()) {
            AppMethods.alertWithOk(this, getString(R.string.enter_confirm_password));
        } else if (!signup_con_password_et.getText().toString().equals(signup_password_et.getText().toString())) {
            AppMethods.alertWithOk(this, getString(R.string.password_does_match));
        } else {
            signUpConfrimNumber(signup_number_et.getText().toString());
        }
    }

    public void signUpApi() {
        if (AppMethods.isConnectingToInternet(this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.create_account);

                JSONObject job = new JSONObject();
                job.put(AppStrings.InputParams.FirstName, signup_name_et.getText().toString());
                job.put(AppStrings.InputParams.LastName, signup_last_name_et.getText().toString());
                job.put(AppStrings.InputParams.EmailID, signup_email_et.getText().toString());
                job.put(AppStrings.InputParams.PhoneNumber, signup_number_et.getText().toString());
                job.put(AppStrings.InputParams.Password, signup_password_et.getText().toString());

                jo.put(AppStrings.InputParams.params, job);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.create_account, jo);
        } else {
            AppMethods.alertForNoInternet(this);
        }
    }


    public void signUpConfrimNumber(String phone) {
        final Dialog dialog = new Dialog(this);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        dialog.setContentView(R.layout.phone_number_verification);
        TextView phone_number_et = (TextView) dialog.findViewById(R.id.phone_number_et);
        TextView dialog_cancel_tv = (TextView) dialog.findViewById(R.id.dialog_cancel_tv);
        TextView dialog_submit_tv = (TextView) dialog.findViewById(R.id.dialog_submit_tv);
        phone_number_et.setText(phone);
        dialog_submit_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                signUpApi();
                dialog.cancel();
            }
        });
        dialog_cancel_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.cancel();
            }
        });
        dialog.show();
        dialog.setCanceledOnTouchOutside(false);
    }


    public void signUpResponse(String response) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {
                String userdetails = jo.optString(AppStrings.OutputParams.userdetails);
                JSONObject job = new JSONObject(userdetails);
                String OTP = job.optString(AppStrings.OutputParams.OTP);
                String FirstName = job.optString(AppStrings.OutputParams.FirstName);
                String LastName = job.optString(AppStrings.OutputParams.LastName);
                String EmailID = job.optString(AppStrings.OutputParams.EmailID);
                String PhoneNumber = job.optString(AppStrings.OutputParams.PhoneNumber);
                String Password = job.optString(AppStrings.OutputParams.Password);


                intent = new Intent(this, OtpVerification.class);
                intent.putExtra(AppStrings.IntentData.phoneNumber, PhoneNumber);
                startActivityForResult(intent, AppIntegers.signup_frag);
            } else {
                AppMethods.alertWithOk(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.signup_tv:
                validation();
                break;
            case R.id.signup_login_tv:
                intent = new Intent(this, AssistantActivity.class);
                startActivity(intent);
                finish();
                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        if (URL.equals(RestApis.create_account)) {
            signUpResponse(response);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == AppIntegers.signup_frag) {
            if (data != null) {

//                 LinphoneAddress.TransportType transport = LinphoneAddress.TransportType.LinphoneTransportUdp;
                intent = new Intent(this, AssistantActivity.class);
                intent.putExtra("asdf", 1);
                startActivity(intent);
            }
        }
    }

}
