package org.linphone.bluereach;

import android.os.Bundle;

import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatCheckBox;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

public class LocationSettingsActivity extends AppCompatActivity implements AsyncHttpResponse.AsyncHttpResponseListener
        , View.OnClickListener {
    private static final String TAG = "LocationSettingsActivit";
    CheckBox loca_set_default_cb, loca_set_one_cb, loca_set_two_cb, loca_set_three_cb, loca_set_four_cb, loca_set_five_cb;
    EditText loc_default_et, loc_one_et, loc_two_et, loc_three_et, loc_four_et, loc_five_et;
    TextView location_default_tv, location_one_tv, location_two_tv, location_three_tv, location_four_tv, location_five_tv;
    SessionManager sessionManager;

    String location_profiles_disabled, location_profile2_enable="0",
            location_profile5_longitude, location_profile5_name,
            location_profile4_name, location_profile1_latitude,
            location_profile2_name, location_profile3_enable="0",
            location_profile2_radius, location_profile5_latitude,
            location_profile1_radius, location_profile2_latitude,
            location_profile3_name, location_profile1_longitude,
            location_profile1_enable="0", location_profile5_enable="0",
            location_profile3_longitude, location_profile4_radius,
            location_profile3_latitude, location_profile4_enable="0",
            location_profile4_longitude, location_profile3_radius,
            location_profile5_radius, location_profile2_longitude,
            location_profile4_latitude, location_profile1_name;


    ImageView back_iv;
    TextView title_tv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_location_settings);
        init();


    }

    public void init() {

        sessionManager = new SessionManager(this);

        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);

        title_tv.setText(R.string.location_setting);


        loca_set_default_cb = (CheckBox) findViewById(R.id.loca_set_default_cb);
        loca_set_one_cb = (CheckBox) findViewById(R.id.loca_set_one_cb);
        loca_set_two_cb = (CheckBox) findViewById(R.id.loca_set_two_cb);
        loca_set_three_cb = (CheckBox) findViewById(R.id.loca_set_three_cb);
        loca_set_four_cb = (CheckBox) findViewById(R.id.loca_set_four_cb);
        loca_set_five_cb = (CheckBox) findViewById(R.id.loca_set_five_cb);


        loc_default_et = (EditText) findViewById(R.id.loc_default_et);
        loc_one_et = (EditText) findViewById(R.id.loc_one_et);
        loc_two_et = (EditText) findViewById(R.id.loc_two_et);
        loc_three_et = (EditText) findViewById(R.id.loc_three_et);
        loc_four_et = (EditText) findViewById(R.id.loc_four_et);
        loc_five_et = (EditText) findViewById(R.id.loc_five_et);


        location_default_tv = (TextView) findViewById(R.id.location_default_tv);
        location_one_tv = (TextView) findViewById(R.id.location_one_tv);
        location_two_tv = (TextView) findViewById(R.id.location_two_tv);
        location_three_tv = (TextView) findViewById(R.id.location_three_tv);
        location_four_tv = (TextView) findViewById(R.id.location_four_tv);
        location_five_tv = (TextView) findViewById(R.id.location_five_tv);
        LocationSettingsApicall();


        checkboxListeners((AppCompatCheckBox) loca_set_default_cb, AppStrings.Constants.default_profile);
        checkboxListeners((AppCompatCheckBox) loca_set_one_cb, AppStrings.Constants.profile_one);
        checkboxListeners((AppCompatCheckBox) loca_set_two_cb, AppStrings.Constants.profile_two);
        checkboxListeners((AppCompatCheckBox) loca_set_three_cb, AppStrings.Constants.profile_three);
        checkboxListeners((AppCompatCheckBox) loca_set_four_cb, AppStrings.Constants.profile_four);
        checkboxListeners((AppCompatCheckBox) loca_set_five_cb, AppStrings.Constants.profile_five);
        back_iv.setOnClickListener(this);
    }


    public void checkboxListeners(final AppCompatCheckBox checkBox, final String status) {
        /*checkbox listhners*/

        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {


                if (checkBox.isPressed()) {
                    if (checkBox.isChecked()) {

//                        if (status.equals(AppStrings.Constants.default_profile)) {
//                            enableDisableAll(true, AppStrings.Constants.on);
//                        } else {
                            setCheckBox(checkBox, status,true);

//                        }
                    } else {

//                        if (status.equals(AppStrings.Constants.default_profile)) {
//                            enableDisableAll(false, AppStrings.Constants.off);
//                        }
//                        else {
                            setCheckBox(checkBox, status,false);

//                        }
                    }
                }

            }
        });
    }


    public void setCheckBox(AppCompatCheckBox checkBox, String status,boolean sat) {

        if (status.equals(AppStrings.Constants.default_profile)) {

            if(sat){
                location_profiles_disabled = AppStrings.Constants.on;

            }
            else{
                location_profiles_disabled = AppStrings.Constants.off;

            }
        }
        if (status.equals(AppStrings.Constants.profile_one)) {
            if(sat){
                location_profile1_enable = AppStrings.Constants.on;
            }else{
                location_profile1_enable = AppStrings.Constants.off;
            }

        }
        if (status.equals(AppStrings.Constants.profile_two)) {
            if(sat){
                location_profile2_enable = AppStrings.Constants.on;
            }else {
                location_profile2_enable = AppStrings.Constants.off;
            }

        }
        if (status.equals(AppStrings.Constants.profile_three)) {
            if(sat){
                location_profile3_enable = AppStrings.Constants.on;
            }else{
                location_profile3_enable = AppStrings.Constants.off;
            }

        }
        if (status.equals(AppStrings.Constants.profile_four)) {
            if(sat){
                location_profile4_enable = AppStrings.Constants.on;
            }else
            {
                location_profile4_enable = AppStrings.Constants.off;
            }

        }
        if (status.equals(AppStrings.Constants.profile_five)) {
            if(sat){
                location_profile5_enable = AppStrings.Constants.on;
            }else{
                location_profile5_enable = AppStrings.Constants.off;
            }

        }
        checkBox.setChecked(sat);


//        enableAllCheck();



    }
    public void enableAllCheck(){
        if(location_profile5_enable.equals("1")&&location_profile4_enable.equals("1")
                &&location_profile3_enable.equals("1")&&location_profile2_enable.equals("1")
                &&location_profile1_enable.equals("1")){
            location_profiles_disabled = AppStrings.Constants.on;

            loca_set_default_cb.setChecked(true);
        }
        else{
            location_profiles_disabled = AppStrings.Constants.off;
            loca_set_default_cb.setChecked(false);

        }
    }

    public void enableDisableAll(boolean bool, String status_enable) {

        location_profiles_disabled = status_enable;
        location_profile1_enable = status_enable;
        location_profile2_enable = status_enable;
        location_profile3_enable = status_enable;
        location_profile4_enable = status_enable;
        location_profile5_enable = status_enable;

            loca_set_one_cb.setChecked(bool);
            loca_set_two_cb.setChecked(bool);
            loca_set_three_cb.setChecked(bool);
            loca_set_five_cb.setChecked(bool);
            loca_set_four_cb.setChecked(bool);


    }

    public void LocationSettingsApicall() {

        if (AppMethods.isConnectingToInternet(this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, false);
            JSONObject jo = null;
            try {

                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.get_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                jo.put(AppStrings.InputParams.profile, AppStrings.Constants.default_profile);

                JSONObject job = new JSONObject();


                job.put(AppStrings.LocationSettings.location_profiles_disabled, AppStrings.LocationSettings.location_profiles_disabled);
                job.put(AppStrings.LocationSettings.location_profile1_enable, AppStrings.LocationSettings.location_profile1_enable);
                job.put(AppStrings.LocationSettings.location_profile1_name, AppStrings.LocationSettings.location_profile1_name);
                job.put(AppStrings.LocationSettings.location_profile1_radius, AppStrings.LocationSettings.location_profile1_radius);
                job.put(AppStrings.LocationSettings.location_profile1_longitude, AppStrings.LocationSettings.location_profile1_longitude);
                job.put(AppStrings.LocationSettings.location_profile1_latitude, AppStrings.LocationSettings.location_profile1_latitude);

                job.put(AppStrings.LocationSettings.location_profile2_enable, AppStrings.LocationSettings.location_profile2_enable);
                job.put(AppStrings.LocationSettings.location_profile2_name, AppStrings.LocationSettings.location_profile2_name);
                job.put(AppStrings.LocationSettings.location_profile2_radius, AppStrings.LocationSettings.location_profile2_radius);
                job.put(AppStrings.LocationSettings.location_profile2_longitude, AppStrings.LocationSettings.location_profile2_longitude);
                job.put(AppStrings.LocationSettings.location_profile2_latitude, AppStrings.LocationSettings.location_profile2_latitude);

                job.put(AppStrings.LocationSettings.location_profile3_enable, AppStrings.LocationSettings.location_profile3_enable);
                job.put(AppStrings.LocationSettings.location_profile3_name, AppStrings.LocationSettings.location_profile3_name);
                job.put(AppStrings.LocationSettings.location_profile3_radius, AppStrings.LocationSettings.location_profile3_radius);
                job.put(AppStrings.LocationSettings.location_profile3_longitude, AppStrings.LocationSettings.location_profile3_longitude);
                job.put(AppStrings.LocationSettings.location_profile3_latitude, AppStrings.LocationSettings.location_profile3_latitude);

                job.put(AppStrings.LocationSettings.location_profile4_enable, AppStrings.LocationSettings.location_profile4_enable);
                job.put(AppStrings.LocationSettings.location_profile4_name, AppStrings.LocationSettings.location_profile4_name);
                job.put(AppStrings.LocationSettings.location_profile4_radius, AppStrings.LocationSettings.location_profile4_radius);
                job.put(AppStrings.LocationSettings.location_profile4_longitude, AppStrings.LocationSettings.location_profile4_longitude);
                job.put(AppStrings.LocationSettings.location_profile4_latitude, AppStrings.LocationSettings.location_profile4_latitude);

                job.put(AppStrings.LocationSettings.location_profile5_enable, AppStrings.LocationSettings.location_profile5_enable);
                job.put(AppStrings.LocationSettings.location_profile5_name, AppStrings.LocationSettings.location_profile5_name);
                job.put(AppStrings.LocationSettings.location_profile5_radius, AppStrings.LocationSettings.location_profile5_radius);
                job.put(AppStrings.LocationSettings.location_profile5_longitude, AppStrings.LocationSettings.location_profile5_longitude);
                job.put(AppStrings.LocationSettings.location_profile5_latitude, AppStrings.LocationSettings.location_profile5_latitude);
                jo.put(AppStrings.InputParams.params, job);



            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(this);
        }
    }

    public void updateLocationSettingsApicall() {

        if (AppMethods.isConnectingToInternet(this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, false);
            JSONObject jo = null;
            try {

                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.set_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                jo.put(AppStrings.InputParams.profile, AppStrings.Constants.default_profile);

                JSONObject job = new JSONObject();

                job.put(AppStrings.LocationSettings.location_profiles_disabled, location_profiles_disabled);

                job.put(AppStrings.LocationSettings.location_profile1_enable, location_profile1_enable);
                job.put(AppStrings.LocationSettings.location_profile1_name, location_one_tv.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile1_radius, loc_one_et.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile1_longitude, location_profile1_longitude);
                job.put(AppStrings.LocationSettings.location_profile1_latitude, location_profile1_latitude);

                job.put(AppStrings.LocationSettings.location_profile2_enable, location_profile2_enable);
                job.put(AppStrings.LocationSettings.location_profile2_name, location_two_tv.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile2_radius, loc_two_et.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile2_longitude, location_profile2_longitude);
                job.put(AppStrings.LocationSettings.location_profile2_latitude, location_profile2_latitude);

                job.put(AppStrings.LocationSettings.location_profile3_enable, location_profile3_enable);
                job.put(AppStrings.LocationSettings.location_profile3_name, location_three_tv.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile3_radius, loc_three_et.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile3_longitude, location_profile3_longitude);
                job.put(AppStrings.LocationSettings.location_profile3_latitude, location_profile3_latitude);

                job.put(AppStrings.LocationSettings.location_profile4_enable, location_profile4_enable);
                job.put(AppStrings.LocationSettings.location_profile4_name, location_four_tv.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile4_radius, loc_four_et.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile4_longitude, location_profile4_longitude);
                job.put(AppStrings.LocationSettings.location_profile4_latitude, location_profile4_latitude);

                job.put(AppStrings.LocationSettings.location_profile5_enable, location_profile5_enable);
                job.put(AppStrings.LocationSettings.location_profile5_name, location_five_tv.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile5_radius, loc_five_et.getText().toString());
                job.put(AppStrings.LocationSettings.location_profile5_longitude, location_profile5_longitude);
                job.put(AppStrings.LocationSettings.location_profile5_latitude, location_profile5_latitude);
                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.set_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(this);
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {

        if (URL.equals(RestApis.get_voip_params)) {
            getLocationSettingsResponse(response, RestApis.get_voip_params);
        } else if (URL.equals(RestApis.set_voip_params)) {
            getLocationSettingsResponse(response, RestApis.set_voip_params);
        }

    }

    public void getLocationSettingsResponse(String response, String url) {


        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {
                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));

                    location_profiles_disabled = job.getString(AppStrings.LocationSettings.location_profiles_disabled);
//                    loc_default_et.setEnabled(false);

                    location_profile1_latitude = job.getString(AppStrings.LocationSettings.location_profile1_latitude);
                    location_profile1_radius = job.getString(AppStrings.LocationSettings.location_profile1_radius);
                    location_profile1_longitude = job.getString(AppStrings.LocationSettings.location_profile1_longitude);
                    location_profile1_enable = job.getString(AppStrings.LocationSettings.location_profile1_enable);
                    location_profile1_name = job.getString(AppStrings.LocationSettings.location_profile1_name);


                    location_profile2_name = job.getString(AppStrings.LocationSettings.location_profile2_name);
                    location_profile2_radius = job.getString(AppStrings.LocationSettings.location_profile2_radius);
                    location_profile2_latitude = job.getString(AppStrings.LocationSettings.location_profile2_latitude);
                    location_profile2_longitude = job.getString(AppStrings.LocationSettings.location_profile2_longitude);
                    location_profile2_enable = job.getString(AppStrings.LocationSettings.location_profile2_enable);


                    location_profile3_name = job.getString(AppStrings.LocationSettings.location_profile3_name);
                    location_profile3_longitude = job.getString(AppStrings.LocationSettings.location_profile3_longitude);
                    location_profile3_latitude = job.getString(AppStrings.LocationSettings.location_profile3_latitude);
                    location_profile3_radius = job.getString(AppStrings.LocationSettings.location_profile3_radius);
                    location_profile3_enable = job.getString(AppStrings.LocationSettings.location_profile3_enable);


                    location_profile4_name = job.getString(AppStrings.LocationSettings.location_profile4_name);
                    location_profile4_radius = job.getString(AppStrings.LocationSettings.location_profile4_radius);
                    location_profile4_enable = job.getString(AppStrings.LocationSettings.location_profile4_enable);
                    location_profile4_longitude = job.getString(AppStrings.LocationSettings.location_profile4_longitude);
                    location_profile4_latitude = job.getString(AppStrings.LocationSettings.location_profile4_latitude);

                    location_profile5_latitude = job.getString(AppStrings.LocationSettings.location_profile5_latitude);
                    location_profile5_enable = job.getString(AppStrings.LocationSettings.location_profile5_enable);
                    location_profile5_longitude = job.getString(AppStrings.LocationSettings.location_profile5_longitude);
                    location_profile5_name = job.getString(AppStrings.LocationSettings.location_profile5_name);
                    location_profile5_radius = job.getString(AppStrings.LocationSettings.location_profile5_radius);




                    settingTextView();



                    settingNameTextView();
                    setEnable();



                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);
                    AppMethods.hideSoftKeyboard(this);
                    finish();
                }


            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void settingTextView() {



        if (location_profile1_radius.equals("")) {
            loc_one_et.setText(getResources().getString(R.string._50));

        } else {

            loc_one_et.setText(location_profile1_radius);

        }
        if (location_profile2_radius.equals("")) {

            loc_two_et.setText(getResources().getString(R.string._50));


        } else {
            loc_two_et.setText(location_profile2_radius);
        }

        if (location_profile3_radius.equals("")) {

            loc_three_et.setText(getResources().getString(R.string._50));


        } else {
            loc_three_et.setText(location_profile3_radius);
        }
        if (location_profile4_radius.equals("")) {

            loc_four_et.setText(getResources().getString(R.string._50));


        } else {
            loc_four_et.setText(location_profile4_radius);
        }
        if (location_profile5_radius.equals("")) {

            loc_five_et.setText(getResources().getString(R.string._50));


        } else {
            loc_five_et.setText(location_profile5_radius);
        }

    }
    public void settingNameTextView() {


        if (location_profile1_name.equals("")) {
            location_one_tv.setText(getResources().getString(R.string.profile_1));

        } else {

            location_one_tv.setText(location_profile1_name);

        }
        if (location_profile2_name.equals("")) {

            location_two_tv.setText(getResources().getString(R.string.profile_2));


        } else {
            location_two_tv.setText(location_profile2_name);
        }

        if (location_profile3_name.equals("")) {

            location_three_tv.setText(getResources().getString(R.string.profile_3));


        } else {
            location_three_tv.setText(location_profile3_name);
        }
        if (location_profile4_name.equals("")) {

            location_four_tv.setText(getResources().getString(R.string.profile_4));


        } else {
            location_four_tv.setText(location_profile4_name);
        }
        if (location_profile5_name.equals("")) {

            location_five_tv.setText(getResources().getString(R.string.profile_5));


        } else {
            location_five_tv.setText(location_profile5_name);
        }

    }



    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.back_iv:
                updateLocationSettingsApicall();
                break;
        }
    }


    public void setEnable() {



        if (location_profiles_disabled.equals(AppStrings.Constants.on)) {
            loca_set_default_cb.setChecked(true);
        } else if (location_profiles_disabled.equals(AppStrings.Constants.off)) {
            loca_set_default_cb.setChecked(false);
        }





        if (location_profile1_enable.equals(AppStrings.Constants.on)) {
            loca_set_one_cb.setChecked(true);
        } else if (location_profile1_enable.equals(AppStrings.Constants.off)) {
            loca_set_one_cb.setChecked(false);
        }


        if (location_profile2_enable.equals(AppStrings.Constants.on)) {
            loca_set_two_cb.setChecked(true);
        } else if (location_profile2_enable.equals(AppStrings.Constants.off)) {
            loca_set_two_cb.setChecked(false);
        }

        if (location_profile3_enable.equals(AppStrings.Constants.on)) {
            loca_set_three_cb.setChecked(true);
        } else if (location_profile3_enable.equals(AppStrings.Constants.off)) {
            loca_set_three_cb.setChecked(false);
        }


        if (location_profile4_enable.equals(AppStrings.Constants.on)) {
            loca_set_four_cb.setChecked(true);
        } else if (location_profile4_enable.equals(AppStrings.Constants.off)) {
            loca_set_four_cb.setChecked(false);
        }


        if (location_profile5_enable.equals(AppStrings.Constants.on)) {
            loca_set_five_cb.setChecked(true);
        } else if (location_profile5_enable.equals(AppStrings.Constants.off)) {
            loca_set_five_cb.setChecked(false);
        }

    }


}
