package org.linphone.bluereach;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.services.PlayLocation;
import org.linphone.utils.AppAlertsDialog;
import org.linphone.utils.AppIntegers;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;


public class LocationProfileFragment extends Fragment implements View.OnClickListener,
        AsyncHttpResponse.AsyncHttpResponseListener, AppAlertsDialog.AppAlertsDialogListener {

    private static final String TAG = "LocationProfileFragment";
    View view;
    EditText profile_default_et, profile_one_et, profile_two_et, profile_three_et, profile_four_et, profile_five_et;
    ImageView edit_default_iv, edit_one_iv, edit_two_iv, edit_three_iv, edit_four_iv, edit_five_iv;
    ImageView save_default_iv, save_one_iv, save_two_iv, save_three_iv, save_four_iv, save_five_iv;
    ImageView del_one_iv, del_two_iv, del_three_iv, del_four_iv, del_five_iv;
    LinearLayout prof_one_ll, prof_two_ll, prof_three_ll, prof_four_ll, prof_five_ll;
    SessionManager sessionManager;
    String profile_type = "", delete_type = "";
    String profile_name = "";
    String latitude = "", longitude;
    String delete_one_type = "", delete_two_type = "", delete_three_type = "", delete_four_type = "", delete_five_type = "";
    String location_profiles_disabled="",location_profiles_radius="",
            location_profile5_longitude = "", location_profile5_name,
            location_profile4_name, location_profile1_latitude = "",
            location_profile2_name,
            location_profile5_latitude = "",
            location_profile2_latitude = "",
            location_profile3_name, location_profile1_longitude = "",
            location_profile3_longitude = "",
            location_profile3_latitude = "",
            location_profile4_longitude = "",
            location_profile2_longitude = "", location_profile4_latitude = "",
            location_profile5_radius="", location_profile4_radius="", location_profile3_radius="", location_profile2_radius="", location_profile1_radius="",
            location_profile1_name,location_profile4_enable="0",location_profile2_enable="0", location_profile3_enable="0", location_profile1_enable="0", location_profile5_enable="0";

    public LocationProfileFragment() {
        // Required empty public constructor
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        view = inflater.inflate(R.layout.fragment_location_profile, container, false);
        init();
        return view;
    }

    public void init() {

        sessionManager = new SessionManager(getActivity());

        profile_default_et = (EditText) view.findViewById(R.id.profile_default_et);
        profile_one_et = (EditText) view.findViewById(R.id.profile_one_et);
        profile_two_et = (EditText) view.findViewById(R.id.profile_two_et);
        profile_three_et = (EditText) view.findViewById(R.id.profile_three_et);
        profile_four_et = (EditText) view.findViewById(R.id.profile_four_et);
        profile_five_et = (EditText) view.findViewById(R.id.profile_five_et);


        edit_default_iv = (ImageView) view.findViewById(R.id.edit_default_iv);
        edit_one_iv = (ImageView) view.findViewById(R.id.edit_one_iv);
        edit_two_iv = (ImageView) view.findViewById(R.id.edit_two_iv);
        edit_three_iv = (ImageView) view.findViewById(R.id.edit_three_iv);
        edit_four_iv = (ImageView) view.findViewById(R.id.edit_four_iv);
        edit_five_iv = (ImageView) view.findViewById(R.id.edit_five_iv);


        save_default_iv = (ImageView) view.findViewById(R.id.save_default_iv);
        save_one_iv = (ImageView) view.findViewById(R.id.save_one_iv);
        save_two_iv = (ImageView) view.findViewById(R.id.save_two_iv);
        save_three_iv = (ImageView) view.findViewById(R.id.save_three_iv);
        save_four_iv = (ImageView) view.findViewById(R.id.save_four_iv);
        save_five_iv = (ImageView) view.findViewById(R.id.save_five_iv);


        del_one_iv = (ImageView) view.findViewById(R.id.del_one_iv);
        del_two_iv = (ImageView) view.findViewById(R.id.del_two_iv);
        del_three_iv = (ImageView) view.findViewById(R.id.del_three_iv);
        del_four_iv = (ImageView) view.findViewById(R.id.del_four_iv);
        del_five_iv = (ImageView) view.findViewById(R.id.del_five_iv);


        prof_one_ll = (LinearLayout) view.findViewById(R.id.prof_one_ll);
        prof_two_ll = (LinearLayout) view.findViewById(R.id.prof_two_ll);
        prof_three_ll = (LinearLayout) view.findViewById(R.id.prof_three_ll);
        prof_four_ll = (LinearLayout) view.findViewById(R.id.prof_four_ll);
        prof_five_ll = (LinearLayout) view.findViewById(R.id.prof_five_ll);

        edit_default_iv.setOnClickListener(this);
        edit_one_iv.setOnClickListener(this);
        edit_two_iv.setOnClickListener(this);
        edit_three_iv.setOnClickListener(this);
        edit_four_iv.setOnClickListener(this);
        edit_five_iv.setOnClickListener(this);

        save_default_iv.setOnClickListener(this);
        save_one_iv.setOnClickListener(this);
        save_two_iv.setOnClickListener(this);
        save_three_iv.setOnClickListener(this);
        save_four_iv.setOnClickListener(this);
        save_five_iv.setOnClickListener(this);


        del_one_iv.setOnClickListener(this);
        del_two_iv.setOnClickListener(this);
        del_three_iv.setOnClickListener(this);
        del_four_iv.setOnClickListener(this);
        del_five_iv.setOnClickListener(this);

        prof_one_ll.setOnClickListener(this);
        prof_two_ll.setOnClickListener(this);
        prof_three_ll.setOnClickListener(this);
        prof_four_ll.setOnClickListener(this);
        prof_five_ll.setOnClickListener(this);

        editButtonClick(profile_one_et);
        editButtonClick(profile_two_et);
        editButtonClick(profile_three_et);
        editButtonClick(profile_four_et);
        editButtonClick(profile_five_et);


        attachOnTouchAndFocusListener(profile_one_et, edit_one_iv, save_one_iv, AppStrings.Constants.profile_one,location_profile1_enable,location_profile1_radius);
        attachOnTouchAndFocusListener(profile_two_et, edit_two_iv, save_two_iv,AppStrings.Constants.profile_two,location_profile2_enable,location_profile2_radius);
        attachOnTouchAndFocusListener(profile_three_et, edit_three_iv, save_three_iv,AppStrings.Constants.profile_three,location_profile3_enable,location_profile3_radius);
        attachOnTouchAndFocusListener(profile_four_et, edit_four_iv, save_four_iv,AppStrings.Constants.profile_four,location_profile4_enable,location_profile4_radius);
        attachOnTouchAndFocusListener(profile_five_et, edit_five_iv, save_five_iv,AppStrings.Constants.profile_five,location_profile5_enable,location_profile5_radius);

//        getUpdateLocationProfileApicall(RestApis.get_voip_params, AppStrings.UpdateLocation.latitude, AppStrings.UpdateLocation.longitude);
        LocationSettingsApicall();



    }

    public void editButtonClick(EditText editText) {
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if ((event != null && (event.getKeyCode() == KeyEvent.KEYCODE_ENTER)) || (actionId == EditorInfo.IME_ACTION_DONE)) {
                    updateOnDoneButtonClick();

                }
                return false;
            }
        });
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.edit_default_iv:
                profile_type = AppStrings.Constants.default_profile;


//                enableDisable(edit_default_iv, save_default_iv, profile_default_et, false);

                break;
            case R.id.edit_one_iv:
                profile_type = AppStrings.Constants.profile_one;

                enableDisable(edit_one_iv, save_one_iv, profile_one_et, true);


                break;
            case R.id.edit_two_iv:
                profile_type = AppStrings.Constants.profile_two;


                enableDisable(edit_two_iv, save_two_iv, profile_two_et, true);

                break;
            case R.id.edit_three_iv:
                profile_type = AppStrings.Constants.profile_three;

                enableDisable(edit_three_iv, save_three_iv, profile_three_et, true);

                break;
            case R.id.edit_four_iv:

                profile_type = AppStrings.Constants.profile_four;

                enableDisable(edit_four_iv, save_four_iv, profile_four_et, true);


                break;
            case R.id.edit_five_iv:

                profile_type = AppStrings.Constants.profile_five;


                enableDisable(edit_five_iv, save_five_iv, profile_five_et, true);

                break;


            case R.id.save_default_iv:

                enableDisable(save_default_iv, edit_default_iv, profile_default_et, false);

                break;
            case R.id.save_one_iv:
                location_profiles_disabled=location_profile1_enable;
                location_profiles_radius=location_profile1_radius;
                profile_name = profile_one_et.getText().toString();

                enableDisable(save_one_iv, edit_one_iv, profile_one_et, false);

                break;
            case R.id.save_two_iv:
                location_profiles_disabled=location_profile2_enable;
                location_profiles_radius=location_profile2_radius;

                profile_name = profile_two_et.getText().toString();

                enableDisable(save_two_iv, edit_two_iv, profile_two_et, false);


                break;
            case R.id.save_three_iv:
                location_profiles_disabled=location_profile3_enable;
                location_profiles_radius=location_profile3_radius;

                profile_name = profile_three_et.getText().toString();

                enableDisable(save_three_iv, edit_three_iv, profile_three_et, false);


                break;
            case R.id.save_four_iv:
                location_profiles_disabled=location_profile4_enable;
                location_profiles_radius=location_profile4_radius;

                profile_name = profile_four_et.getText().toString();

                enableDisable(save_four_iv, edit_four_iv, profile_four_et, false);


                break;
            case R.id.save_five_iv:
                location_profiles_disabled=location_profile5_enable;
                location_profiles_radius=location_profile5_radius;

                profile_name = profile_five_et.getText().toString();

                enableDisable(save_five_iv, edit_five_iv, profile_five_et, false);


                break;


            case R.id.del_one_iv:

                profile_type = AppStrings.Constants.profile_one;
                location_profiles_disabled=AppStrings.Constants.off;


                delete_one_type = AppStrings.Constants.profile_one;


                AppAlertsDialog dialog1 = new AppAlertsDialog(LocationProfileFragment.this);
                dialog1.logoutAlert(LocationProfileFragment.this, getString(R.string.delete_alert), delete_one_type);


                break;
            case R.id.del_two_iv:
                location_profiles_disabled=AppStrings.Constants.off;
                profile_type = AppStrings.Constants.profile_two;

                delete_two_type = AppStrings.Constants.profile_two;


                AppAlertsDialog dialog2 = new AppAlertsDialog(LocationProfileFragment.this);
                dialog2.logoutAlert(LocationProfileFragment.this, getString(R.string.delete_alert), delete_two_type);


                break;
            case R.id.del_three_iv:
                location_profiles_disabled=AppStrings.Constants.off;
                profile_type = AppStrings.Constants.profile_three;

                delete_three_type = AppStrings.Constants.profile_three;


                AppAlertsDialog dialog3 = new AppAlertsDialog(LocationProfileFragment.this);
                dialog3.logoutAlert(LocationProfileFragment.this, getString(R.string.delete_alert), delete_three_type);


                break;
            case R.id.del_four_iv:
                location_profiles_disabled=AppStrings.Constants.off;
                profile_type = AppStrings.Constants.profile_four;

                delete_four_type = AppStrings.Constants.profile_four;

                AppAlertsDialog dialog4 = new AppAlertsDialog(LocationProfileFragment.this);
                dialog4.logoutAlert(LocationProfileFragment.this, getString(R.string.delete_alert), delete_four_type);


                break;
            case R.id.del_five_iv:
                location_profiles_disabled=AppStrings.Constants.off;
                profile_type = AppStrings.Constants.profile_five;


                delete_five_type = AppStrings.Constants.profile_five;

                AppAlertsDialog dialog5 = new AppAlertsDialog(LocationProfileFragment.this);
                dialog5.logoutAlert(LocationProfileFragment.this, getString(R.string.delete_alert), delete_five_type);


                break;
        }
    }

    public void enableDisable(ImageView edit_image, ImageView save_image, EditText editText, boolean enable_status) {
        if (enable_status) {
            editText.setSelection(editText.getText().toString().length());
            editText.requestFocus();
            edit_image.setVisibility(View.GONE);
            save_image.setVisibility(View.VISIBLE);

        } else {

            edit_image.setVisibility(View.VISIBLE);
            save_image.setVisibility(View.GONE);
            try {
                AppMethods.closeKeyboardAlert(getActivity());
            } catch (Exception e) {
                e.printStackTrace();
            }


            if (AppMethods.checkingLocationPermissions(getActivity())) {
                if (!AppMethods.checkGpsOnOff(getActivity())) {
                    AppMethods.ShowGpsAlert(getActivity(), getString(R.string.alert_enable_gps), "");
                    AppMethods.startLocationService(getActivity());
                } else {
                    sendingLatLongs();
                }
            } else {
                AppMethods.checkingLocationPermissions(getActivity());
            }


        }


    }

    public void updateEnableDisable(ImageView edit_image, ImageView save_image, EditText editText, boolean enable_status) {
        if (enable_status) {
            editText.setSelection(editText.getText().toString().length());
            editText.requestFocus();
            edit_image.setVisibility(View.GONE);
            save_image.setVisibility(View.VISIBLE);

        } else {
            edit_image.setVisibility(View.VISIBLE);
            save_image.setVisibility(View.GONE);
        }


    }


    public void location(String latitude, String longitude) {



        Intent intent = new Intent(getActivity(), Location.class);
        intent.putExtra(AppStrings.IntentData.latitude, latitude);
        intent.putExtra(AppStrings.IntentData.longitude, longitude);
        startActivityForResult(intent, AppIntegers.SET_LOCATION_REQUEST_CODE);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (resultCode == AppIntegers.SET_LOCATION_REQUEST_CODE) {
            if (data != null) {
                String address_from_location = data.getStringExtra(AppStrings.Location.myaddress);
                String latitude_from_address = data.getStringExtra(AppStrings.Location.latitude_intent);
                String longitude_from_address = data.getStringExtra(AppStrings.Location.longitude_intent);
                enableMethods();


                updateLocationProfileApicall(RestApis.set_voip_params, latitude_from_address, longitude_from_address);


            } else {
                enableMethods();
            }
        }


    }

    public void updateLocationProfileApicall(String action, String latitude, String longitude) {
        updateEnableDisabled(false);
        if (AppMethods.isConnectingToInternet(getActivity())) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {

                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                jo.put(AppStrings.InputParams.profile, profile_type);

                JSONObject job = new JSONObject();


                job.put(AppStrings.LocationSettingsProf.location_profile + profile_type + AppStrings.LocationSettingsNames._name, profile_name);
                job.put(AppStrings.LocationSettingsProf.location_profile + profile_type + AppStrings.LocationSettingsNames._longitude, longitude);
                job.put(AppStrings.LocationSettingsProf.location_profile + profile_type + AppStrings.LocationSettingsNames._latitude, latitude);
                job.put(AppStrings.LocationSettingsProf.location_profile + profile_type + AppStrings.LocationSettingsNames._latitude, latitude);
                job.put(AppStrings.LocationSettingsProf.location_profile + profile_type + AppStrings.LocationSettingsNames._enable, location_profiles_disabled);
                job.put(AppStrings.LocationSettingsProf.location_profile + profile_type + AppStrings.LocationSettingsNames._radius, location_profiles_radius);


                jo.put(AppStrings.InputParams.params, job);

            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, action, jo);
        } else {
            AppMethods.alertForNoInternet(getActivity());
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        if (URL.equals(RestApis.get_voip_params)) {
            getLocationSettingsResponse(response, RestApis.get_voip_params);
        } else {
            edit_default_iv.setVisibility(View.VISIBLE);
            profile_one_et.setVisibility(View.VISIBLE);
            profile_two_et.setVisibility(View.VISIBLE);
            profile_three_et.setVisibility(View.VISIBLE);
            profile_four_et.setVisibility(View.VISIBLE);
            profile_five_et.setVisibility(View.VISIBLE);
            updateLocationSettingsResponse(response, RestApis.set_voip_params);
        }
    }


    public void LocationSettingsApicall() {
        updateEnableDisabled(false);
        if (AppMethods.isConnectingToInternet(getActivity())) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.get_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                jo.put(AppStrings.InputParams.profile, AppStrings.Constants.default_profile);

                JSONObject job = new JSONObject();


                job.put(AppStrings.LocationSettings.location_profiles_disabled, AppStrings.LocationSettings.location_profiles_disabled);

                job.put(AppStrings.LocationSettings.location_profile1_enable, AppStrings.LocationSettings.location_profile1_enable);
                job.put(AppStrings.LocationSettings.location_profile1_name, AppStrings.LocationSettings.location_profile1_name);
                job.put(AppStrings.LocationSettings.location_profile1_longitude, AppStrings.LocationSettings.location_profile1_longitude);
                job.put(AppStrings.LocationSettings.location_profile1_latitude, AppStrings.LocationSettings.location_profile1_latitude);
                job.put(AppStrings.LocationSettings.location_profile1_radius, AppStrings.LocationSettings.location_profile1_radius);

                job.put(AppStrings.LocationSettings.location_profile2_enable, AppStrings.LocationSettings.location_profile2_enable);
                job.put(AppStrings.LocationSettings.location_profile2_name, AppStrings.LocationSettings.location_profile2_name);
                job.put(AppStrings.LocationSettings.location_profile2_longitude, AppStrings.LocationSettings.location_profile2_longitude);
                job.put(AppStrings.LocationSettings.location_profile2_latitude, AppStrings.LocationSettings.location_profile2_latitude);
                job.put(AppStrings.LocationSettings.location_profile2_radius, AppStrings.LocationSettings.location_profile2_radius);


                job.put(AppStrings.LocationSettings.location_profile3_enable, AppStrings.LocationSettings.location_profile3_enable);

                job.put(AppStrings.LocationSettings.location_profile3_name, AppStrings.LocationSettings.location_profile3_name);
                job.put(AppStrings.LocationSettings.location_profile3_longitude, AppStrings.LocationSettings.location_profile3_longitude);
                job.put(AppStrings.LocationSettings.location_profile3_latitude, AppStrings.LocationSettings.location_profile3_latitude);
                job.put(AppStrings.LocationSettings.location_profile3_radius, AppStrings.LocationSettings.location_profile3_radius);


                job.put(AppStrings.LocationSettings.location_profile4_enable, AppStrings.LocationSettings.location_profile4_enable);

                job.put(AppStrings.LocationSettings.location_profile4_name, AppStrings.LocationSettings.location_profile4_name);
                job.put(AppStrings.LocationSettings.location_profile4_longitude, AppStrings.LocationSettings.location_profile4_longitude);
                job.put(AppStrings.LocationSettings.location_profile4_latitude, AppStrings.LocationSettings.location_profile4_latitude);
                job.put(AppStrings.LocationSettings.location_profile4_radius, AppStrings.LocationSettings.location_profile4_radius);

                job.put(AppStrings.LocationSettings.location_profile5_enable, AppStrings.LocationSettings.location_profile5_enable);

                job.put(AppStrings.LocationSettings.location_profile5_name, AppStrings.LocationSettings.location_profile5_name);
                job.put(AppStrings.LocationSettings.location_profile5_longitude, AppStrings.LocationSettings.location_profile5_longitude);
                job.put(AppStrings.LocationSettings.location_profile5_latitude, AppStrings.LocationSettings.location_profile5_latitude);
                job.put(AppStrings.LocationSettings.location_profile5_radius, AppStrings.LocationSettings.location_profile5_radius);
                jo.put(AppStrings.InputParams.params, job);



            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(getActivity());
        }
    }

    public void getLocationSettingsResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {
                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));

                    location_profiles_disabled = job.getString(AppStrings.LocationSettings.location_profiles_disabled);


                    location_profile1_latitude = job.getString(AppStrings.LocationSettings.location_profile1_latitude);
                    location_profile1_longitude = job.getString(AppStrings.LocationSettings.location_profile1_longitude);
                    location_profile1_name = job.getString(AppStrings.LocationSettings.location_profile1_name);
                    location_profile1_enable = job.getString(AppStrings.LocationSettings.location_profile1_enable);
                    location_profile1_radius = job.getString(AppStrings.LocationSettings.location_profile1_radius);


                    location_profile2_name = job.getString(AppStrings.LocationSettings.location_profile2_name);
                    location_profile2_latitude = job.getString(AppStrings.LocationSettings.location_profile2_latitude);
                    location_profile2_longitude = job.getString(AppStrings.LocationSettings.location_profile2_longitude);
                    location_profile2_enable = job.getString(AppStrings.LocationSettings.location_profile2_enable);
                    location_profile2_radius = job.getString(AppStrings.LocationSettings.location_profile2_radius);



                    location_profile3_name = job.getString(AppStrings.LocationSettings.location_profile3_name);
                    location_profile3_longitude = job.getString(AppStrings.LocationSettings.location_profile3_longitude);
                    location_profile3_latitude = job.getString(AppStrings.LocationSettings.location_profile3_latitude);
                    location_profile3_enable = job.getString(AppStrings.LocationSettings.location_profile3_enable);
                    location_profile3_radius = job.getString(AppStrings.LocationSettings.location_profile3_radius);



                    location_profile4_name = job.getString(AppStrings.LocationSettings.location_profile4_name);
                    location_profile4_longitude = job.getString(AppStrings.LocationSettings.location_profile4_longitude);
                    location_profile4_latitude = job.getString(AppStrings.LocationSettings.location_profile4_latitude);
                    location_profile4_enable = job.getString(AppStrings.LocationSettings.location_profile4_enable);
                    location_profile4_radius = job.getString(AppStrings.LocationSettings.location_profile4_radius);

                    location_profile5_latitude = job.getString(AppStrings.LocationSettings.location_profile5_latitude);
                    location_profile5_longitude = job.getString(AppStrings.LocationSettings.location_profile5_longitude);
                    location_profile5_name = job.getString(AppStrings.LocationSettings.location_profile5_name);
                    location_profile5_enable = job.getString(AppStrings.LocationSettings.location_profile5_enable);
                    location_profile5_radius = job.getString(AppStrings.LocationSettings.location_profile5_radius);

                    settingTextView();


                }


            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateLocationSettingsResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {
                updateEnableDisabled(true);

                updateEnableDisable(edit_one_iv, save_one_iv, profile_one_et, false);
                updateEnableDisable(edit_two_iv, save_one_iv, profile_two_et, false);
                updateEnableDisable(edit_three_iv, save_one_iv, profile_three_et, false);
                updateEnableDisable(edit_four_iv, save_one_iv, profile_four_et, false);
                updateEnableDisable(edit_five_iv, save_one_iv, profile_five_et, false);


                AppMethods.showToast(getActivity(), Message);
                AppMethods.hideSoftKeyboard(getActivity());
                LocationSettingsApicall();

            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void enableEdits() {
        edit_default_iv.setVisibility(View.VISIBLE);
        profile_one_et.setVisibility(View.VISIBLE);
        profile_two_et.setVisibility(View.VISIBLE);
        profile_three_et.setVisibility(View.VISIBLE);
        profile_four_et.setVisibility(View.VISIBLE);
        profile_five_et.setVisibility(View.VISIBLE);


        save_one_iv.setVisibility(View.GONE);
        save_two_iv.setVisibility(View.GONE);
        save_three_iv.setVisibility(View.GONE);
        save_four_iv.setVisibility(View.GONE);
        save_five_iv.setVisibility(View.GONE);


    }

    public void settingTextView() {

        profile_one_et.setVisibility(View.VISIBLE);
        profile_one_et.setEnabled(true);
        save_one_iv.setVisibility(View.GONE);

        profile_two_et.setVisibility(View.VISIBLE);
        profile_two_et.setEnabled(true);
        save_two_iv.setVisibility(View.GONE);

        profile_three_et.setVisibility(View.VISIBLE);
        profile_three_et.setEnabled(true);
        save_three_iv.setVisibility(View.GONE);

        profile_four_et.setVisibility(View.VISIBLE);
        profile_four_et.setEnabled(true);
        save_four_iv.setVisibility(View.GONE);

        profile_five_et.setVisibility(View.VISIBLE);
        profile_five_et.setEnabled(true);
        save_five_iv.setVisibility(View.GONE);


        if (location_profile1_name.equals("")) {
            profile_one_et.setText(R.string.profile_1);


        } else {

            profile_one_et.setText(location_profile1_name);
        }
        if (location_profile2_name.equals("")) {

            profile_two_et.setText(R.string.profile_2);


        } else {
            profile_two_et.setText(location_profile2_name);
        }

        if (location_profile3_name.equals("")) {

            profile_three_et.setText(R.string.profile_3);


        } else {
            profile_three_et.setText(location_profile3_name);
        }
        if (location_profile4_name.equals("")) {

            profile_four_et.setText(R.string.profile_4);


        } else {
            profile_four_et.setText(location_profile4_name);
        }
        if (location_profile5_name.equals("")) {

            profile_five_et.setText(R.string.profile_5);


        } else {
            profile_five_et.setText(location_profile5_name);
        }
        updateEnableDisabled(true);
    }

    public void sendingLatLongs() {


        if (profile_type.equals(AppStrings.Constants.profile_one)) {
            if (location_profile1_latitude.equals("") || location_profile1_latitude == null || location_profile1_longitude.equals("") || location_profile1_longitude == null) {
                location(String.valueOf(PlayLocation.playlat), String.valueOf(PlayLocation.playlog));

            } else {

                location(String.valueOf(location_profile1_latitude), String.valueOf(location_profile1_longitude));
            }
        }
        if (profile_type.equals(AppStrings.Constants.profile_two)) {
            if (location_profile2_latitude.equals("") || location_profile2_latitude == null || location_profile2_longitude.equals("") || location_profile2_longitude == null) {
                location(String.valueOf(PlayLocation.playlat), String.valueOf(PlayLocation.playlog));

            } else {

                location(String.valueOf(location_profile2_latitude), String.valueOf(location_profile2_longitude));
            }
        }
        if (profile_type.equals(AppStrings.Constants.profile_three)) {
            if (location_profile3_latitude.equals("") || location_profile3_latitude == null || location_profile3_longitude.equals("") || location_profile3_longitude == null) {
                location(String.valueOf(PlayLocation.playlat), String.valueOf(PlayLocation.playlog));

            } else {

                location(String.valueOf(location_profile3_latitude), String.valueOf(location_profile3_longitude));
            }
        }
        if (profile_type.equals(AppStrings.Constants.profile_four)) {
            if (location_profile4_latitude.equals("") || location_profile4_latitude == null || location_profile4_longitude.equals("") || location_profile4_longitude == null) {
                location(String.valueOf(PlayLocation.playlat), String.valueOf(PlayLocation.playlog));

            } else {

                location(String.valueOf(location_profile4_latitude), String.valueOf(location_profile4_longitude));
            }
        }
        if (profile_type.equals(AppStrings.Constants.profile_five)) {
            if (location_profile5_latitude.equals("") || location_profile5_latitude == null || location_profile5_longitude.equals("") || location_profile5_longitude == null) {
                location(String.valueOf(PlayLocation.playlat), String.valueOf(PlayLocation.playlog));

            } else {

                location(String.valueOf(location_profile5_latitude), String.valueOf(location_profile5_longitude));
            }

        }


    }

    @Override
    public void onAlertTypeGET(int type) throws Exception {


    }

    @Override
    public void onAlertTypeGET(int type, String str) throws Exception {



        if (type == AppIntegers.logout_okay) {
            location_profiles_disabled=AppStrings.Constants.off;
            location_profiles_radius="";

            visibilityRedirection(str, str);
//            visibility();
        } else if (type == AppIntegers.logout_cancel) {
//            visibilityRedirection(str, "");
//            visibility();
        }
    }

    @Override
    public void onAlertTypeGET(String type) throws Exception {
    }

    public void visibility() {


        if (sessionManager.getStoreData(AppStrings.Session.delete_one_type).equals(AppStrings.Constants.profile_one)) {

            prof_one_ll.setVisibility(View.GONE);

        } else {
            prof_one_ll.setVisibility(View.VISIBLE);

        }
        if (sessionManager.getStoreData(AppStrings.Session.delete_two_type).equals(AppStrings.Constants.profile_two)) {

            prof_two_ll.setVisibility(View.GONE);

        } else {
            prof_two_ll.setVisibility(View.VISIBLE);

        }
        if (sessionManager.getStoreData(AppStrings.Session.delete_three_type).equals(AppStrings.Constants.profile_three)) {

            prof_three_ll.setVisibility(View.GONE);

        } else {
            prof_three_ll.setVisibility(View.VISIBLE);

        }
        if (sessionManager.getStoreData(AppStrings.Session.delete_four_type).equals(AppStrings.Constants.profile_four)) {

            prof_four_ll.setVisibility(View.GONE);

        } else {
            prof_four_ll.setVisibility(View.VISIBLE);

        }
        if (sessionManager.getStoreData(AppStrings.Session.delete_five_type).equals(AppStrings.Constants.profile_five)) {

            prof_five_ll.setVisibility(View.GONE);

        } else {
            prof_five_ll.setVisibility(View.VISIBLE);

        }


    }

    public void visibilityRedirection(String status_, String status_from) {



        if (status_.equals(AppStrings.Constants.profile_one)) {

            sessionManager.setStoreData(AppStrings.Session.delete_one_type, status_from);

            profile_one_et.setText("");
        }

        if (status_.equals(AppStrings.Constants.profile_two)) {

            sessionManager.setStoreData(AppStrings.Session.delete_two_type, status_from);

            profile_two_et.setText("");
        }
        if (status_.equals(AppStrings.Constants.profile_three)) {

            sessionManager.setStoreData(AppStrings.Session.delete_three_type, status_from);
            profile_three_et.setText("");

        }
        if (status_.equals(AppStrings.Constants.profile_four)) {

            sessionManager.setStoreData(AppStrings.Session.delete_four_type, status_from);

            profile_four_et.setText("");
        }
        if (status_.equals(AppStrings.Constants.profile_five)) {

            sessionManager.setStoreData(AppStrings.Session.delete_five_type, status_from);
            profile_five_et.setText("");

        }
        profile_name = "";

        if (!status_from.equals("")) {
            updateLocationProfileApicall(RestApis.set_voip_params, "", "");

        }


    }

    public void enableMethods() {


        updateEnableDisable(edit_one_iv, save_one_iv, profile_one_et, false);
        updateEnableDisable(edit_two_iv, save_one_iv, profile_two_et, false);
        updateEnableDisable(edit_three_iv, save_one_iv, profile_three_et, false);
        updateEnableDisable(edit_four_iv, save_one_iv, profile_four_et, false);
        updateEnableDisable(edit_five_iv, save_one_iv, profile_five_et, false);

    }

    public void attachOnTouchAndFocusListener(final EditText editText, final ImageView edit_image, final ImageView save_image,final String type,final  String enable_Status,final  String radius) {
        final String text = editText.getText().toString().trim();
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if (hasFocus) {
                    // check if keyboard is connected but accessibility services
                    // are disabled
                    profile_type = type;
                    location_profiles_disabled=enable_Status;
                    location_profiles_radius=radius;

                    edit_image.setVisibility(View.GONE);
                    save_image.setVisibility(View.VISIBLE);
                } else {
                    edit_image.setVisibility(View.VISIBLE);
                    save_image.setVisibility(View.GONE);


                }
            }
        });
    }

    public void updateOnDoneButtonClick() {
        if (profile_type.equals(AppStrings.Constants.profile_one)) {
            profile_name = profile_one_et.getText().toString();
            location_profiles_disabled=  location_profile1_enable;
            location_profiles_radius=  location_profile1_radius;

            updateLocationProfileApicall(RestApis.set_voip_params, location_profile1_latitude, location_profile1_longitude);


        } else if (profile_type.equals(AppStrings.Constants.profile_two)) {
            location_profiles_disabled=  location_profile2_enable;
            profile_name = profile_two_et.getText().toString();
            location_profiles_radius=  location_profile2_radius;

            updateLocationProfileApicall(RestApis.set_voip_params, location_profile2_latitude, location_profile2_longitude);


        } else if (profile_type.equals(AppStrings.Constants.profile_three)) {
            location_profiles_radius=  location_profile3_radius;

            profile_name = profile_three_et.getText().toString();
            location_profiles_disabled=  location_profile3_enable;

            updateLocationProfileApicall(RestApis.set_voip_params, location_profile3_latitude, location_profile3_longitude);


        } else if (profile_type.equals(AppStrings.Constants.profile_four)) {
            profile_name = profile_four_et.getText().toString();
            location_profiles_radius=  location_profile4_radius;

            location_profiles_disabled=  location_profile4_enable;

            updateLocationProfileApicall(RestApis.set_voip_params, location_profile4_latitude, location_profile4_longitude);


        } else if (profile_type.equals(AppStrings.Constants.profile_five)) {
            profile_name = profile_five_et.getText().toString();
            location_profiles_disabled=  location_profile5_enable;
            location_profiles_radius=  location_profile5_radius;

            updateLocationProfileApicall(RestApis.set_voip_params, location_profile5_latitude, location_profile5_longitude);

        }

    }

    public void updateEnableDisabled(boolean edit_bool) {
        edit_one_iv.setClickable(edit_bool);
        edit_two_iv.setClickable(edit_bool);
        edit_three_iv.setClickable(edit_bool);
        edit_four_iv.setClickable(edit_bool);
        edit_five_iv.setClickable(edit_bool);
    }
}
