package org.linphone.bluereach;

import android.graphics.Color;
import android.os.Bundle;

import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toolbar;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.bluereach.handlers.HuntGroupAdapter;
import org.linphone.bluereach.models.HuntGroupModel;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HuntGroupActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {

    private static final String TAG = "HuntGroupActivity";
    RecyclerView hunt_group_rv;
    HuntGroupAdapter adapter;
    ArrayList<HuntGroupModel> arrayList;
    LinearLayoutManager manager;
    CheckBox hunt_enable_cb;
    String hunt_enable_cb_status = "0", hunt_sp_status = "0";
    ArrayList<String> hunt_name_array;
    ArrayList<String> hunt_name_id_array;
    AppCompatSpinner hunt_sp;

    EditText hunt_seconds_et;

    ImageView back_iv;
    TextView title_tv;
    SessionManager sessionManager;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_hunt_group);
        androidx.appcompat.widget.Toolbar toolbar = (androidx.appcompat.widget.Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        initUI();

    }

    public void initUI() {
        sessionManager = new SessionManager(this);
        arrayList = new ArrayList<>();
        hunt_group_rv = (RecyclerView) findViewById(R.id.hunt_group_rv);
        adapter = new HuntGroupAdapter(this, arrayList);
        manager = new LinearLayoutManager(this);
        hunt_group_rv.setAdapter(adapter);
        hunt_group_rv.setLayoutManager(manager);

        hunt_seconds_et = (EditText) findViewById(R.id.hunt_seconds_et);
        hunt_name_array = new ArrayList<>();
        hunt_name_id_array = new ArrayList<>();

        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);

        title_tv.setText(getResources().getString(R.string.hunt_group));

        /*adding drop down data */

        List<String> call_forward_names = Arrays.asList(getResources().getStringArray(R.array.call_forward_names));
        List<String> cal_forward_id = Arrays.asList(getResources().getStringArray(R.array.cal_forward_id));

        for (int i = 0; i < call_forward_names.size(); i++) {
            hunt_name_array.add(call_forward_names.get(i));
        }
        for (int i = 0; i < cal_forward_id.size(); i++) {
            hunt_name_id_array.add(cal_forward_id.get(i));
        }
        hunt_sp = (AppCompatSpinner) findViewById(R.id.hunt_sp);
        hunt_enable_cb = (CheckBox) findViewById(R.id.hunt_enable_cb);


        /*checkbox functionality */
        spinnerFunctionality();


        hunt_enable_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (hunt_enable_cb.isPressed()) {

                    if (hunt_enable_cb.isChecked()) {
                        hunt_enable_cb_status = AppStrings.Constants.on;
                    } else {
                        hunt_enable_cb_status = AppStrings.Constants.off;
                    }
                }
            }
        });


        setData();


        back_iv.setOnClickListener(this);

        /*performing get hunt group action here */

        huntGroupApiCall(getJson(), RestApis.get_voip_params);

    }

    public void setData() {


        String[] extension = {"1st", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th", "9th", "10th"};
        for (int i = 0; i < 10; i++) {
            HuntGroupModel model = new HuntGroupModel();
            model.setHuntGroupNumber("");
            model.setHuntGroupTimeout("");

            model.setHuntGroupNumberHint(extension[i] + " " + getResources().getString(R.string.hunt_group_number));
            arrayList.add(model);
        }
        adapter.notifyDataSetChanged();
    }

    public void updateDataNumber(int pos, String data) {
        try {
            arrayList.get(pos).setHuntGroupNumber(data);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDataTimeout(int pos, String data) {
        try {
            arrayList.get(pos).setHuntGroupTimeout(data);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject updateJson() {
        JSONObject job_obj = new JSONObject();

        try {
            job_obj.put(AppStrings.HuntGroup.huntgroup_status, hunt_enable_cb_status);
            job_obj.put(AppStrings.HuntGroup.huntgroup_time, hunt_sp_status);
            job_obj.put(AppStrings.HuntGroup.huntgroup_timeout, hunt_seconds_et.getText().toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 10; i++) {


            try {
                job_obj.put(AppStrings.HuntGroup.huntgroup_number + (i + 1), arrayList.get(i).getHuntGroupNumber());
                job_obj.put(AppStrings.HuntGroup.huntgroup_timeout + (i + 1), arrayList.get(i).getHuntGroupTimeout());

            } catch (Exception e) {
                e.printStackTrace();
            }

        }


        return job_obj;
    }

    public JSONObject getJson() {
        JSONObject job_obj = new JSONObject();


        try {
            job_obj.put(AppStrings.HuntGroup.huntgroup_status, AppStrings.HuntGroup.huntgroup_status);
            job_obj.put(AppStrings.HuntGroup.huntgroup_time, AppStrings.HuntGroup.huntgroup_time);
            job_obj.put(AppStrings.HuntGroup.huntgroup_timeout, AppStrings.HuntGroup.huntgroup_timeout);
        } catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 10; i++) {
            try {
                job_obj.put(AppStrings.HuntGroup.huntgroup_number + (i + 1), AppStrings.HuntGroup.huntgroup_number + (i + 1));
                job_obj.put(AppStrings.HuntGroup.huntgroup_timeout + (i + 1), AppStrings.HuntGroup.huntgroup_timeout + (i + 1));

            } catch (Exception e) {
                e.printStackTrace();
            }

        }


        return job_obj;
    }

    public void huntGroupResponse(String response, String url) {
        try {
            JSONObject jsonObject = new JSONObject(response);
            String Status = jsonObject.optString(AppStrings.OutputParams.Status);
            String Message = jsonObject.optString(AppStrings.OutputParams.Message);


            if (Status.equals(AppStrings.OutputParams.Success)) {


                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject params = new JSONObject(jsonObject.getString(AppStrings.InputParams.params));
                    hunt_enable_cb_status = params.getString(AppStrings.HuntGroup.huntgroup_status);
                    hunt_sp_status = params.getString(AppStrings.HuntGroup.huntgroup_time);
                    hunt_seconds_et.setText(params.getString(AppStrings.HuntGroup.huntgroup_timeout));


                    for (int i = 0; i < hunt_name_array.size(); i++) {
                        if (hunt_name_id_array.get(i).equals(hunt_sp_status)) {
                            hunt_sp.setSelection(i);
                        }
                    }


                    if (hunt_enable_cb_status.equals(AppStrings.Constants.on)) {
                        hunt_enable_cb.setChecked(true);
                    } else {
                        hunt_enable_cb.setChecked(false);
                    }


                    String huntgroup_number1 = params.getString(AppStrings.HuntGroup.huntgroup_number1);
                    String huntgroup_timeout1 = params.getString(AppStrings.HuntGroup.huntgroup_timeout1);

                    HuntGroupModel model1 = new HuntGroupModel();
                    model1.setHuntGroupNumber(huntgroup_number1);
                    if (huntgroup_timeout1.equals("")) {
                        model1.setHuntGroupTimeout("10");
                    } else {
                        model1.setHuntGroupTimeout(huntgroup_timeout1);
                    }
                    model1.setHuntGroupNumberHint("1st" + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(0, model1);

                    String huntgroup_number2 = params.getString(AppStrings.HuntGroup.huntgroup_number2);
                    String huntgroup_timeout2 = params.getString(AppStrings.HuntGroup.huntgroup_timeout2);

                    HuntGroupModel model2 = new HuntGroupModel();
                    model2.setHuntGroupNumber(huntgroup_number2);
                    if (huntgroup_timeout2.equals("")) {
                        model2.setHuntGroupTimeout("10");
                    } else {
                        model2.setHuntGroupTimeout(huntgroup_timeout2);
                    }
                    model2.setHuntGroupNumberHint("2nd " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(1, model2);

                    String huntgroup_number3 = params.getString(AppStrings.HuntGroup.huntgroup_number3);
                    String huntgroup_timeout3 = params.getString(AppStrings.HuntGroup.huntgroup_timeout3);

                    HuntGroupModel model3 = new HuntGroupModel();
                    model3.setHuntGroupNumber(huntgroup_number3);
                    if (huntgroup_timeout3.equals("")) {
                        model3.setHuntGroupTimeout("10");
                    } else {
                        model3.setHuntGroupTimeout(huntgroup_timeout3);
                    }
                    model3.setHuntGroupNumberHint("3rd" + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(2, model3);

                    String huntgroup_number4 = params.getString(AppStrings.HuntGroup.huntgroup_number4);
                    String huntgroup_timeout4 = params.getString(AppStrings.HuntGroup.huntgroup_timeout4);

                    HuntGroupModel model4 = new HuntGroupModel();
                    model4.setHuntGroupNumber(huntgroup_number4);
                    if (huntgroup_timeout4.equals("")) {
                        model4.setHuntGroupTimeout("10");
                    } else {
                        model4.setHuntGroupTimeout(huntgroup_timeout4);
                    }
                    model4.setHuntGroupNumberHint("4th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(3, model4);

                    String huntgroup_number5 = params.getString(AppStrings.HuntGroup.huntgroup_number5);
                    String huntgroup_timeout5 = params.getString(AppStrings.HuntGroup.huntgroup_timeout5);

                    HuntGroupModel model5 = new HuntGroupModel();
                    model5.setHuntGroupNumber(huntgroup_number5);
                    if (huntgroup_timeout5.equals("")) {
                        model5.setHuntGroupTimeout("10");
                    } else {
                        model5.setHuntGroupTimeout(huntgroup_timeout5);
                    }
                    model5.setHuntGroupNumberHint("5th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(4, model5);

                    String huntgroup_number6 = params.getString(AppStrings.HuntGroup.huntgroup_number6);
                    String huntgroup_timeout6 = params.getString(AppStrings.HuntGroup.huntgroup_timeout6);

                    HuntGroupModel model6 = new HuntGroupModel();
                    model6.setHuntGroupNumber(huntgroup_number6);
                    if (huntgroup_timeout6.equals("")) {
                        model6.setHuntGroupTimeout("10");
                    } else {
                        model6.setHuntGroupTimeout(huntgroup_timeout6);
                    }
                    model6.setHuntGroupNumberHint("6th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(5, model6);

                    String huntgroup_number7 = params.getString(AppStrings.HuntGroup.huntgroup_number7);
                    String huntgroup_timeout7 = params.getString(AppStrings.HuntGroup.huntgroup_timeout7);

                    HuntGroupModel model7 = new HuntGroupModel();
                    model7.setHuntGroupNumber(huntgroup_number7);
                    if (huntgroup_timeout7.equals("")) {
                        model7.setHuntGroupTimeout("10");
                    } else {
                        model7.setHuntGroupTimeout(huntgroup_timeout7);
                    }
                    model7.setHuntGroupNumberHint("7th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(6, model7);

                    String huntgroup_number8 = params.getString(AppStrings.HuntGroup.huntgroup_number8);
                    String huntgroup_timeout8 = params.getString(AppStrings.HuntGroup.huntgroup_timeout8);

                    HuntGroupModel model8 = new HuntGroupModel();
                    model8.setHuntGroupNumber(huntgroup_number8);
                    if (huntgroup_timeout8.equals("")) {
                        model8.setHuntGroupTimeout("10");
                    } else {
                        model8.setHuntGroupTimeout(huntgroup_timeout8);
                    }
                    model8.setHuntGroupNumberHint("8th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(7, model8);

                    String huntgroup_number9 = params.getString(AppStrings.HuntGroup.huntgroup_number9);
                    String huntgroup_timeout9 = params.getString(AppStrings.HuntGroup.huntgroup_timeout9);

                    HuntGroupModel model9 = new HuntGroupModel();
                    model9.setHuntGroupNumber(huntgroup_number9);
                    if (huntgroup_timeout9.equals("")) {
                        model9.setHuntGroupTimeout("10");
                    } else {
                        model9.setHuntGroupTimeout(huntgroup_timeout9);
                    }
                    model9.setHuntGroupNumberHint("9th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(8, model9);

                    String huntgroup_number10 = params.getString(AppStrings.HuntGroup.huntgroup_number10);
                    String huntgroup_timeout10 = params.getString(AppStrings.HuntGroup.huntgroup_timeout10);

                    HuntGroupModel model10 = new HuntGroupModel();
                    model10.setHuntGroupNumber(huntgroup_number10);
                    if (huntgroup_timeout10.equals("")) {
                        model10.setHuntGroupTimeout("10");
                    } else {
                        model10.setHuntGroupTimeout(huntgroup_timeout10);
                    }
                    model10.setHuntGroupNumberHint("10th " + " " + getResources().getString(R.string.hunt_group_number));
                    arrayList.set(9, model10);


                    adapter.notifyDataSetChanged();

                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);

                    finish();
                }

            } else {
                AppMethods.showToast(this, Message);
            }


        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void ondata(View view) {
        Log.e(TAG, "ondata: " + " " + updateJson());
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.back_iv:


                /*updating hunt group data*/
                huntGroupApiCall(updateJson(), RestApis.set_voip_params);
                try {
                    AppMethods.hideSoftKeyboard(this);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        huntGroupResponse(response, URL);
    }


    public void spinnerFunctionality() {


        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(HuntGroupActivity.this, R.layout.custom_spinner, hunt_name_array) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }


        };

        hunt_sp.setAdapter(arrayAdapter);

        hunt_sp.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(hunt_sp.getSelectedItem());


                hunt_sp_status = hunt_name_id_array.get(position);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }


    public void huntGroupApiCall(JSONObject job, String action) {


        if (AppMethods.isConnectingToInternet(HuntGroupActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, action, jo);
        } else {
            AppMethods.alertForNoInternet(HuntGroupActivity.this);
        }
    }


}
