package org.linphone.bluereach;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatEditText;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.activities.assistant.AssistantActivity;
import org.linphone.activities.assistant.fragments.GenericAccountLoginFragment;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;

import java.net.URL;


public class ForgotPassword extends AppCompatActivity implements AsyncHttpResponse.AsyncHttpResponseListener {
    TextView forgot_password_submit_tv;
    AppCompatEditText forgot_pwd_number_et;
    ImageView back_iv;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.forgot_passeord);
        initUI();
    }

    public void initUI() {
        forgot_password_submit_tv = (TextView) findViewById(R.id.forgot_password_submit_tv);
        forgot_pwd_number_et = (AppCompatEditText) findViewById(R.id.forgot_pwd_number_et);
        back_iv = findViewById(R.id.back_iv);


        /*checking validation and performing forgot password action*/
        forgot_password_submit_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (forgot_pwd_number_et.getText().toString().isEmpty()) {
                    AppMethods.alertWithOk(ForgotPassword.this, getResources().getString(R.string.enter_number));
                } else {
                    forgotPasswordApi();
                }
            }
        });

        /** navigate to sign up page **/
        back_iv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
    }

    public void forgotPasswordApi() {
        if (AppMethods.isConnectingToInternet(this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);

            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.forgot_password);

                JSONObject job = new JSONObject();
                job.put(AppStrings.InputParams.PhoneNumber, forgot_pwd_number_et.getText().toString());

                jo.put(AppStrings.InputParams.params, job);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.forgot_password, jo);

        } else {
            AppMethods.alertForNoInternet(this);
        }
    }

    public void forgotPasswordResponse(String response) {
        Log.e("TAG", "forgotPasswordResponse:" + response);
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {
                alertMessage(Message);
            } else {
                AppMethods.alertWithOk2(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void alertMessage(final String message) {
        AlertDialog.Builder alertDialogBuilder;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            alertDialogBuilder = new AlertDialog.Builder(this, android.R.style.Theme_Material_Light_Dialog_Alert);
        } else {
            alertDialogBuilder = new AlertDialog.Builder(this);
        }
        alertDialogBuilder.setMessage(message).setCancelable(false).
                setPositiveButton(getResources().getString(R.string.ok),
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int id) {
                                Intent intent = new Intent(ForgotPassword.this, AssistantActivity.class);
                                startActivity(intent);
                                finish();
                                dialog.cancel();
                            }
                        });

        AlertDialog alertDialog = alertDialogBuilder.create();
        alertDialog.show();
        alertDialog.getWindow().getAttributes();

        TextView textView = (TextView) alertDialog.findViewById(android.R.id.message);
        textView.setTextSize(16);

        Button btn1 = alertDialog.getButton(DialogInterface.BUTTON_POSITIVE);
        btn1.setTextSize(16);
        btn1.setTextColor(this.getResources().getColor(R.color.blue, null));
        btn1.setInputType(0);
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        if (URL.equals(RestApis.forgot_password)) {
            forgotPasswordResponse(response);
        }
    }
}
