package org.linphone.bluereach;

import android.graphics.Color;
import android.os.Bundle;
;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatSpinner;


import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CallIdScreeningPinCodeDndPersInfoActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {
    CheckBox hide_call_id_cb, notify_65_cb, notify_67_cb, enable_pin_cb, busy_tone_cd, do_not_disturb_status_cb;
    String hide_call_id_status = "0", notify_65_status = "0", notify_67_status = "0", enable_pin_cb_status = "0",
            access_code_tollsonly_status = "", do_not_disturb_time_status = "", busy_tone_cd_status = "0", // Ray Patch
            do_not_disturb_status_cb_status = "0", call_screen_pref_sp_status = "0", call_screen_sched_sp_status = "0";
    LinearLayout hide_call_id_ll, notify_65_ll, notify_67_ll, enable_pin_ll, dand_ll, call_screening_ll;
    AppCompatSpinner extention_dialing_sp, dnd_sp, call_screen_pref_sp, call_screen_sched_sp;
    private static final String TAG = "CallIdScreeningPinCodeD";
    List<String> pin_name_array;
    List<String> pin_name_id_array;


    List<String> dnd_arralist;
    List<String> dnd_id_array;


    List<String> call_pref_name_array;
    List<String> call_pref_id_array;


    List<String> call_pref_time_name_array;
    List<String> call_pref_time_id_array;

    ImageView back_iv;
    TextView title_tv;
    String redirection_status = "";
    LinearLayout callerid_privacy_ll, pin_code_ll, personal_info_ll;
    EditText pin_et, call_id_name_et, short_extension_num_et;
    SessionManager sessionManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_caller_id_and_privacy);
        init();

    }

    public void init() {

        sessionManager = new SessionManager(this);
        redirection_status = getIntent().getStringExtra(AppStrings.IntentData.redirection_status);


        callerid_privacy_ll = (LinearLayout) findViewById(R.id.callerid_privacy_ll);
        pin_code_ll = (LinearLayout) findViewById(R.id.pin_code_ll);
        personal_info_ll = (LinearLayout) findViewById(R.id.personal_info_ll);

        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);
        dand_ll = (LinearLayout) findViewById(R.id.dand_ll);
        call_screening_ll = (LinearLayout) findViewById(R.id.call_screening_ll);


        /*based on status from the PBX settings displaying & hiding layouts*/
        redirectionsSettings();

        pin_name_array = new ArrayList<String>();
        pin_name_id_array = new ArrayList<String>();
        dnd_arralist = new ArrayList<String>();
        dnd_id_array = new ArrayList<String>();
        call_pref_time_name_array = new ArrayList<String>();
        call_pref_time_id_array = new ArrayList<String>();
        call_pref_name_array = new ArrayList<String>();
        call_pref_id_array = new ArrayList<String>();

        pin_name_array.clear();
        pin_name_id_array.clear();
        dnd_arralist.clear();
        dnd_id_array.clear();
        call_pref_time_name_array.clear();
        call_pref_time_id_array.clear();
        call_pref_name_array.clear();
        call_pref_id_array.clear();


        hide_call_id_cb = (CheckBox) findViewById(R.id.hide_call_id_cb);
        notify_65_cb = (CheckBox) findViewById(R.id.notify_65_cb);
        notify_67_cb = (CheckBox) findViewById(R.id.notify_67_cb);
        enable_pin_cb = (CheckBox) findViewById(R.id.enable_pin_cb);
        busy_tone_cd = (CheckBox) findViewById(R.id.busy_tone_cd);
        do_not_disturb_status_cb = (CheckBox) findViewById(R.id.do_not_disturb_status_cb);


        hide_call_id_ll = (LinearLayout) findViewById(R.id.hide_call_id_ll);
        notify_65_ll = (LinearLayout) findViewById(R.id.notify_65_ll);
        notify_67_ll = (LinearLayout) findViewById(R.id.notify_67_ll);
        enable_pin_ll = (LinearLayout) findViewById(R.id.enable_pin_ll);

        pin_et = (EditText) findViewById(R.id.pin_et);
        call_id_name_et = (EditText) findViewById(R.id.call_id_name_et);
        short_extension_num_et = (EditText) findViewById(R.id.short_extension_num_et);

        extention_dialing_sp = (AppCompatSpinner) findViewById(R.id.extention_dialing_sp);
        call_screen_pref_sp = (AppCompatSpinner) findViewById(R.id.call_screen_pref_sp);
        call_screen_sched_sp = (AppCompatSpinner) findViewById(R.id.call_screen_sched_sp);
        dnd_sp = (AppCompatSpinner) findViewById(R.id.dnd_sp);
        hide_call_id_ll.setOnClickListener(this);
        notify_65_ll.setOnClickListener(this);
        notify_67_ll.setOnClickListener(this);
        enable_pin_ll.setOnClickListener(this);


        // Ray Bug Fix pin_name_array.add(getString(R.string.pin_label));
        pin_name_array.add(getString(R.string.pin_all_calls));
        pin_name_array.add(getString(R.string.pin_toll_calls));
        pin_name_array.add(getString(R.string.pin_mobileoverseas_calls)); //Ray Bug Fix
        pin_name_array.add(getString(R.string.pin_overseas_calls));
        pin_name_array.add(getString(R.string.pin_overseasexaus_calls)); //Ray Bug Fix
        pin_name_array.add(getString(R.string.pin_expensive_Sesti));

        // Ray Bug Fix pin_name_id_array.add(getString(R.string.pin_all_calls_id));
        pin_name_id_array.add(getString(R.string.pin_all_calls_id));
        pin_name_id_array.add(getString(R.string.pin_toll_calls_id));
        pin_name_id_array.add(getString(R.string.pin_mobileoverseas_calls_id)); //Ray Bug Fix
        pin_name_id_array.add(getString(R.string.pin_overseas_calls_id));
        pin_name_id_array.add(getString(R.string.pin_overseasexaus_calls_id)); //Ray Bug Fix
        pin_name_id_array.add(getString(R.string.pin_expensive_Sesti_id));
        back_iv.setOnClickListener(this);

        List<String> name_one = Arrays.asList(getResources().getStringArray(R.array.call_forward_names));
        List<String> id_one = Arrays.asList(getResources().getStringArray(R.array.cal_forward_id));
        List<String> call_scrren_name = Arrays.asList(getResources().getStringArray(R.array.call_scrren_name));
        List<String> call_scrren_name_id = Arrays.asList(getResources().getStringArray(R.array.call_scrren_name_id));

        for (int i = 0; i < name_one.size(); i++) {
            dnd_arralist.add(name_one.get(i));
            call_pref_time_name_array.add(name_one.get(i));

        }
        for (int i = 0; i < id_one.size(); i++) {
            dnd_id_array.add(id_one.get(i));
            call_pref_time_id_array.add(id_one.get(i));
        }
        for (int i = 0; i < call_scrren_name.size(); i++) {
            call_pref_name_array.add(call_scrren_name.get(i));
        }
        for (int i = 0; i < call_scrren_name_id.size(); i++) {
            call_pref_id_array.add(call_scrren_name_id.get(i));
        }



        /*setting checkboxes */
        hideCallIDFuntion();
        notify65Function();
        notify67Function();
        enablePinFunction();
        FbusyToneFunction();





        do_not_disturb_status_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (do_not_disturb_status_cb.isChecked()) {

                        do_not_disturb_status_cb_status = AppStrings.Constants.on;

                    } else {
                        do_not_disturb_status_cb_status = AppStrings.Constants.off;
                    }
            }
        });


        spinnerFunctionality();/*pincode dropdown listners*/
        dndSpinnerFunctionality();/*dnd dropdown listener*/
        callScreenPrefSpinnerFunctionality();/*call screening listener*/
        callScreenTimeSpinnerFunctionality();/*call screening listeners*/

    }

    public void hideCallIDFuntion(){
        hide_call_id_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                    if (hide_call_id_cb.isChecked()) {
                        hide_call_id_status = AppStrings.Constants.on;
                    } else {
                        hide_call_id_status = AppStrings.Constants.off;
                    }
            }
        });
    }  public void notify65Function(){
        notify_65_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (notify_65_cb.isChecked()) {
                        notify_65_status = AppStrings.Constants.on;
                    } else {
                        notify_65_status = AppStrings.Constants.off;

                    }
            }
        });
    }
         public void notify67Function(){
             notify_67_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                 @Override
                 public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                         if (notify_67_cb.isChecked()) {
                             notify_67_status = AppStrings.Constants.on;
                         } else {
                             notify_67_status = AppStrings.Constants.off;

                         }
                 }
             });
    }

   public void enablePinFunction(){
       enable_pin_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
           @Override
           public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                   if (enable_pin_cb.isChecked()) {

                       enable_pin_cb_status = AppStrings.Constants.on;

                   } else {
                       enable_pin_cb_status = AppStrings.Constants.off;
                   }
           }
       });
    }
          public void FbusyToneFunction(){
              busy_tone_cd.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                  @Override
                  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                          if (busy_tone_cd.isChecked()) {

                              busy_tone_cd_status = AppStrings.Constants.on;

                          } else {
                              busy_tone_cd_status = AppStrings.Constants.off;
                          }
                      }
//                  }
              });
    }


    public void redirectionsSettings() {
        if (redirection_status.equals(AppStrings.Constants.call_id_priv)) {
            callerid_privacy_ll.setVisibility(View.VISIBLE);
            pin_code_ll.setVisibility(View.GONE);
            personal_info_ll.setVisibility(View.GONE);
            dand_ll.setVisibility(View.GONE);
            call_screening_ll.setVisibility(View.GONE);
            title_tv.setText(getResources().getString(R.string.title_activity_caller_id_and_privacy));


            /* performing get caller_id data action */

            getCallerIdApi(RestApis.get_voip_params, RestApis.get_voip_params, AppStrings.CallerIdPrivacyInput.block_callerid,
                    AppStrings.CallerIdPrivacyInput.percall_block_callerid_notify, AppStrings.CallerIdPrivacyInput.percall_allow_callerid_notify);

        } else if (redirection_status.equals(AppStrings.Constants.pincode)) {

            callerid_privacy_ll.setVisibility(View.GONE);
            pin_code_ll.setVisibility(View.VISIBLE);
            personal_info_ll.setVisibility(View.GONE);
            dand_ll.setVisibility(View.GONE);
            call_screening_ll.setVisibility(View.GONE);
            title_tv.setText(getResources().getString(R.string.pin_code));


            /* performing get pin code data action */
            getPinCode(RestApis.get_voip_params, RestApis.get_voip_params, AppStrings.PinCodeInput.access_code_status, AppStrings.PinCodeInput.access_code_number
                    , AppStrings.PinCodeInput.access_code_tollsonly);  //Ray Bug Fix


        } else if (redirection_status.equals(AppStrings.Constants.personal)) {
            callerid_privacy_ll.setVisibility(View.GONE);
            pin_code_ll.setVisibility(View.GONE);
            dand_ll.setVisibility(View.GONE);
            call_screening_ll.setVisibility(View.GONE);
            personal_info_ll.setVisibility(View.VISIBLE);
            title_tv.setText(getResources().getString(R.string.personal_info));

            /* performing get personal info  data action */

            getPersonalInfo(RestApis.get_voip_params, RestApis.get_voip_params, AppStrings.PersonalInfoInput.fullname, AppStrings.PersonalInfoInput.shortextension);
        } else if (redirection_status.equals(AppStrings.Constants.dnd)) {
            callerid_privacy_ll.setVisibility(View.GONE);
            pin_code_ll.setVisibility(View.GONE);
            personal_info_ll.setVisibility(View.GONE);
            dand_ll.setVisibility(View.VISIBLE);
            call_screening_ll.setVisibility(View.GONE);
            title_tv.setText(R.string.do_not_disturb);

            /* performing get DND  data action */

            getDAndD(RestApis.get_voip_params, RestApis.get_voip_params, AppStrings.DAndD.do_not_disturb_status, AppStrings.DAndD.do_not_disturb_time, AppStrings.DAndD.do_not_disturb_busytone);

        } else if (redirection_status.equals(AppStrings.Constants.call_screen)) {
            callerid_privacy_ll.setVisibility(View.GONE);
            pin_code_ll.setVisibility(View.GONE);
            personal_info_ll.setVisibility(View.GONE);
            dand_ll.setVisibility(View.GONE);
            call_screening_ll.setVisibility(View.VISIBLE);
            title_tv.setText(R.string.call_screening);

            /* performing get call_screen  data action */

            CallPreferenceAPiCall(RestApis.get_voip_params, RestApis.get_voip_params, AppStrings.CallScreen.callscreening_type, AppStrings.CallScreen.callscreening_time);
        }

    }

    public void spinnerFunctionality() {
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(CallIdScreeningPinCodeDndPersInfoActivity.this, R.layout.custom_spinner, pin_name_array) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }
        };

        extention_dialing_sp.setAdapter(arrayAdapter);

        extention_dialing_sp.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(extention_dialing_sp.getSelectedItem());

                //Ray Bug Fix if (Text.equals(getResources().getString(R.string.pin_label))) {


                //Ray Bug Fix    autoattendant_status = pin_name_id_array.get(0);


                //Ray Bug Fix } else {
                    access_code_tollsonly_status = pin_name_id_array.get(position); //Ray Bug Fix
                //Ray Bug Fix }


            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }

    public void dndSpinnerFunctionality() {
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(CallIdScreeningPinCodeDndPersInfoActivity.this, R.layout.custom_spinner, dnd_arralist) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }
        };

        dnd_sp.setAdapter(arrayAdapter);

        dnd_sp.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(dnd_sp.getSelectedItem());

                //Ray Bug Fix if (Text.equals(getResources().getString(R.string.pin_label))) {

                //Ray Bug Fix    do_not_disturb_time_status = dnd_id_array.get(0);


                //Ray Bug Fix } else {
                    do_not_disturb_time_status = dnd_id_array.get(position);

                //Ray Bug Fix }

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }

    public void callScreenPrefSpinnerFunctionality() {
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(CallIdScreeningPinCodeDndPersInfoActivity.this, R.layout.custom_spinner, call_pref_name_array) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }
        };

        call_screen_pref_sp.setAdapter(arrayAdapter);

        call_screen_pref_sp.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(call_screen_pref_sp.getSelectedItem());

                    call_screen_pref_sp_status = call_pref_id_array.get(position);


            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }

    public void callScreenTimeSpinnerFunctionality() {
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(CallIdScreeningPinCodeDndPersInfoActivity.this, R.layout.custom_spinner, call_pref_time_name_array) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }
        };

        call_screen_sched_sp.setAdapter(arrayAdapter);

        call_screen_sched_sp.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(call_screen_sched_sp.getSelectedItem());

                    call_screen_sched_sp_status = call_pref_time_id_array.get(position);


            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }

    public void getCallerIdApi(String action, String url_api, String block_callerid, String notify_67, String notify_65) {

        if (AppMethods.isConnectingToInternet(CallIdScreeningPinCodeDndPersInfoActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.CallerIdPrivacyInput.block_callerid, block_callerid);
                job.put(AppStrings.CallerIdPrivacyInput.percall_block_callerid_notify, notify_67);
                job.put(AppStrings.CallerIdPrivacyInput.percall_allow_callerid_notify, notify_65);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, url_api, jo);
        } else {
            AppMethods.alertForNoInternet(CallIdScreeningPinCodeDndPersInfoActivity.this);
        }
    }

    public void getPinCode(String action, String url_api, String enable_pin_cb_status, String pin_text, String access_code_tollsonly_status) { //Ray Bug Fix


        if (AppMethods.isConnectingToInternet(CallIdScreeningPinCodeDndPersInfoActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(CallIdScreeningPinCodeDndPersInfoActivity.this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                JSONObject job = new JSONObject();


                job.put(AppStrings.PinCodeInput.access_code_status, enable_pin_cb_status);
                job.put(AppStrings.PinCodeInput.access_code_number, pin_text);
                job.put(AppStrings.PinCodeInput.access_code_tollsonly, access_code_tollsonly_status); //Ray Bug Fix

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, url_api, jo);
        } else {
            AppMethods.alertForNoInternet(CallIdScreeningPinCodeDndPersInfoActivity.this);
        }
    }

    public void getPersonalInfo(String action, String url_api, String caller_id_name, String short_extension_num) {

        if (AppMethods.isConnectingToInternet(CallIdScreeningPinCodeDndPersInfoActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                JSONObject job = new JSONObject();


                job.put(AppStrings.PersonalInfoInput.fullname, caller_id_name);
                job.put(AppStrings.PersonalInfoInput.shortextension, short_extension_num);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp( RestApis.url, url_api, jo);
        } else {
            AppMethods.alertForNoInternet(CallIdScreeningPinCodeDndPersInfoActivity.this);
        }
    }

    public void getDAndD(String action, String url_api, String do_not_disturb_status, String do_not_disturb_time, String do_not_disturb_busytone) {


        if (AppMethods.isConnectingToInternet(CallIdScreeningPinCodeDndPersInfoActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                JSONObject job = new JSONObject();


                job.put(AppStrings.DAndD.do_not_disturb_status, do_not_disturb_status);
                job.put(AppStrings.DAndD.do_not_disturb_time, do_not_disturb_time);
                job.put(AppStrings.DAndD.do_not_disturb_busytone, do_not_disturb_busytone);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, url_api, jo);
        } else {
            AppMethods.alertForNoInternet(CallIdScreeningPinCodeDndPersInfoActivity.this);
        }
    }

    public void CallPreferenceAPiCall(String action, String url_api, String callscreening_type, String callscreening_time) { //Ray Bug Fix , String callscreening_type) {

        if (AppMethods.isConnectingToInternet(CallIdScreeningPinCodeDndPersInfoActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                 jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, action);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));
                JSONObject job = new JSONObject();
                job.put(AppStrings.CallScreen.callscreening_time, callscreening_time);
                job.put(AppStrings.CallScreen.callscreening_type, callscreening_type);
                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, url_api, jo);
        } else {
            AppMethods.alertForNoInternet(CallIdScreeningPinCodeDndPersInfoActivity.this);
        }
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.hide_call_id_ll:
                break;
            case R.id.notify_65_ll:
                notify_65_cb.performClick();
                break;
            case R.id.notify_67_ll:
                notify_67_cb.performClick();
                break;
            case R.id.enable_pin_ll:
                enable_pin_cb.performClick();
                break;

            case R.id.back_iv:


                /*perfoming update functinality based on status*/
                if (redirection_status.equals(AppStrings.Constants.call_id_priv)) {
                    getCallerIdApi(RestApis.set_voip_params, RestApis.set_voip_params, hide_call_id_status,
                            notify_67_status, notify_65_status);

                } else if (redirection_status.equals(AppStrings.Constants.pincode)) {
                    getPinCode(RestApis.set_voip_params, RestApis.set_voip_params, enable_pin_cb_status, pin_et.getText().toString()
                            , access_code_tollsonly_status); //Ray Bug Fix

                } else if (redirection_status.equals(AppStrings.Constants.personal)) {
                    getPersonalInfo(RestApis.set_voip_params, RestApis.set_voip_params, call_id_name_et.getText().toString(), short_extension_num_et.getText().toString());

                } else if (redirection_status.equals(AppStrings.Constants.dnd)) {
                    getDAndD(RestApis.set_voip_params, RestApis.set_voip_params, do_not_disturb_status_cb_status, do_not_disturb_time_status, busy_tone_cd_status);

                } else if (redirection_status.equals(AppStrings.Constants.call_screen)) {
                    CallPreferenceAPiCall(RestApis.set_voip_params, RestApis.set_voip_params, call_screen_pref_sp_status, call_screen_sched_sp_status);
                }


                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {

        apiResponse(response, URL);
    }


    public void apiResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {


                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));
                    if (redirection_status.equals(AppStrings.Constants.call_id_priv)) {


                        hide_call_id_status = job.getString(AppStrings.CallerIdPrivacyInput.block_callerid);
                        notify_67_status = job.getString(AppStrings.CallerIdPrivacyInput.percall_block_callerid_notify);
                        notify_65_status = job.optString(AppStrings.CallerIdPrivacyInput.percall_allow_callerid_notify);

                        hideCallIDFuntion();
                        notify65Function();
                        notify67Function();

                        if (hide_call_id_status.equals(AppStrings.Constants.on)) {
                            hide_call_id_cb.setChecked(true);
                        } else if (hide_call_id_status.equals(AppStrings.Constants.off)) {
                            hide_call_id_cb.setChecked(false);
                        }
                        if (notify_67_status.equals(AppStrings.Constants.on)) {
                            notify_67_cb.setChecked(true);
                        } else if (notify_67_status.equals(AppStrings.Constants.off)) {
                            notify_67_cb.setChecked(false);
                        }


                        if (notify_65_status.equals(AppStrings.Constants.on)) {
                            notify_65_cb.setChecked(true);
                        } else if (notify_65_status.equals(AppStrings.Constants.off)) {
                            notify_65_cb.setChecked(false);
                        }


                    } else if (redirection_status.equals(AppStrings.Constants.pincode)) {
                        String access_code_tollsonly = job.getString(AppStrings.PinCodeInput.access_code_tollsonly); //Ray Bug Fix
                        enable_pin_cb_status = job.getString(AppStrings.PinCodeInput.access_code_status);
                        pin_et.setText(job.getString(AppStrings.PinCodeInput.access_code_number));


                        for (int i = 0; i < pin_name_array.size(); i++) {
                            if (pin_name_id_array.get(i).equals(access_code_tollsonly)) { //Ray Bug Fix


                                extention_dialing_sp.setSelection(i);
                            }

                        }
                        if (enable_pin_cb_status.equals(AppStrings.Constants.on)) {
                            enable_pin_cb.setChecked(true);
                        } else if (enable_pin_cb_status.equals(AppStrings.Constants.off)) {
                            enable_pin_cb.setChecked(false);
                        }
                        pin_et.setSelection(pin_et.getText().toString().length());

                    } else if (redirection_status.equals(AppStrings.Constants.personal)) {

                        call_id_name_et.setText(job.getString(AppStrings.PersonalInfoInput.fullname));
                        short_extension_num_et.setText(job.getString(AppStrings.PersonalInfoInput.shortextension));
                        call_id_name_et.setSelection(call_id_name_et.getText().toString().length());
                        short_extension_num_et.setSelection(short_extension_num_et.getText().toString().length());

                    } else if (redirection_status.equals(AppStrings.Constants.dnd)) {

                        do_not_disturb_status_cb_status = job.getString(AppStrings.DAndD.do_not_disturb_status);
                        do_not_disturb_time_status = job.getString(AppStrings.DAndD.do_not_disturb_time);
                        busy_tone_cd_status = job.getString(AppStrings.DAndD.do_not_disturb_busytone);


                        if (do_not_disturb_status_cb_status.equals(AppStrings.Constants.on)) {
                            do_not_disturb_status_cb.setChecked(true);

                        } else if (do_not_disturb_status_cb_status.equals(AppStrings.Constants.off)) {
                            do_not_disturb_status_cb.setChecked(false);
                        }
                        if (busy_tone_cd_status.equals(AppStrings.Constants.on)) {
                            busy_tone_cd.setChecked(true);

                        } else if (busy_tone_cd_status.equals(AppStrings.Constants.off)) {
                            busy_tone_cd.setChecked(false);
                        }


                        for (int i = 0; i < dnd_id_array.size(); i++) {
                            if (dnd_id_array.get(i).equals(do_not_disturb_time_status)) {
                                dnd_sp.setSelection(i);
                            }
                        }

                    } else if (redirection_status.equals(AppStrings.Constants.call_screen)) {

                        call_screen_pref_sp_status = job.getString(AppStrings.CallScreen.callscreening_type);
                        call_screen_sched_sp_status = job.getString(AppStrings.CallScreen.callscreening_time);



                        for (int i = 0; i < call_pref_name_array.size(); i++) {
                            //Ray Bug Fix
                            //if (call_pref_id_array.get(i).equals(call_screen_sched_sp_status)) {
                            if (call_pref_id_array.get(i).equals(call_screen_pref_sp_status)) {
                                call_screen_pref_sp.setSelection(i);
                            }
                        }


                        for (int i = 0; i < call_pref_time_name_array.size(); i++) {
                            //Ray Bug Fix
                            //if (call_pref_time_id_array.get(i).equals(call_screen_pref_sp_status)) {
                            if (call_pref_time_id_array.get(i).equals(call_screen_sched_sp_status)) {
                                call_screen_sched_sp.setSelection(i);
                            }
                        }

                    }


                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);
                    AppMethods.hideSoftKeyboard(this);
                    finish();
                }

            } else {
                AppMethods.showToast(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
