package org.linphone.bluereach;

import android.graphics.Color;
import android.os.Bundle;

import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatSpinner;

import com.google.android.material.textfield.TextInputEditText;


import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.bluereach.models.CallForwardingModel;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public class CallForwardingActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {

    private static final String TAG = "CallForwardingActivity";
    AppCompatCheckBox call_forward_always_cb, call_forward_unavai_cb, call_forward_busy_cb, call_forward_offline_cb;
    AppCompatEditText call_forward_always_tie, call_forward_unavai_tie, call_forward_busy_tie, call_forward_offline_tie;
    AppCompatSpinner call_forward_always_spin, call_forward_unavai_spin, call_forward_busy_spin, call_forward_offline_spin;
    String call_forward_always_cb_status = "", call_forward_unavai_cb_status = "", call_forward_busy_cb_status = "", call_forward_offline_cb_status = "";
    ArrayList<CallForwardingModel> call_for_arralist;
    ArrayList<CallForwardingModel> arrayList;
    ImageView back_iv;
    TextView title_tv;
    ArrayList<String> names_one_array;
    ArrayList<String> names_one_id_array;
    String callforward_always_status = "", callforward_always_number = "", callforward_always_time = "", callforward_noanswer_status = "", callforward_noanswer_number = "", callforward_noanswer_time = "", callforward_busy_status = "", callforward_busy_number = "",
            callforward_busy_time = "", callforward_unreachable_status = "", callforward_unreachable_number = "", callforward_unreachable_time = "";
    SessionManager sessionManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_call_forwarding);

        init();
    }

    public void init() {

        sessionManager = new SessionManager(this);
        call_for_arralist = new ArrayList<>();
        arrayList = new ArrayList<>();
        names_one_array = new ArrayList<>();
        names_one_id_array = new ArrayList<>();


        /*adding call forward names and ids data */

        List<String> name_one = Arrays.asList(getResources().getStringArray(R.array.call_forward_names));
        List<String> id_one = Arrays.asList(getResources().getStringArray(R.array.cal_forward_id));

        for (int i = 0; i < name_one.size(); i++) {
            names_one_array.add(name_one.get(i));
        }
        for (int i = 0; i < id_one.size(); i++) {
            names_one_id_array.add(id_one.get(i));
        }


        back_iv = (ImageView) findViewById(R.id.back_iv);
        title_tv = (TextView) findViewById(R.id.title_tv);

        call_forward_always_cb = (AppCompatCheckBox) findViewById(R.id.call_forward_always_cb);
        call_forward_unavai_cb = (AppCompatCheckBox) findViewById(R.id.call_forward_unavai_cb);
        call_forward_busy_cb = (AppCompatCheckBox) findViewById(R.id.call_forward_busy_cb);
        call_forward_offline_cb = (AppCompatCheckBox) findViewById(R.id.call_forward_offline_cb);

        call_forward_always_tie = (AppCompatEditText) findViewById(R.id.call_forward_always_tie);
        call_forward_unavai_tie = (AppCompatEditText) findViewById(R.id.call_forward_unavai_tie);
        call_forward_busy_tie = (AppCompatEditText) findViewById(R.id.call_forward_busy_tie);
        call_forward_offline_tie = (AppCompatEditText) findViewById(R.id.call_forward_offline_tie);

        call_forward_always_spin = (AppCompatSpinner) findViewById(R.id.call_forward_always_spin);
        call_forward_unavai_spin = (AppCompatSpinner) findViewById(R.id.call_forward_unavai_spin);
        call_forward_busy_spin = (AppCompatSpinner) findViewById(R.id.call_forward_busy_spin);
        call_forward_offline_spin = (AppCompatSpinner) findViewById(R.id.call_forward_offline_spin);


        title_tv.setText(getResources().getString(R.string.call_forwarding));


        /*checkbox listhners*/

        call_forward_always_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                if (call_forward_always_cb.isPressed()) {

                if (call_forward_always_cb.isChecked()) {
                    call_forward_always_cb_status = AppStrings.Constants.on;
                } else {
                    call_forward_always_cb_status = AppStrings.Constants.off;
                }
//                }
            }
        });
        call_forward_unavai_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                if (call_forward_unavai_cb.isPressed()) {

                if (call_forward_unavai_cb.isChecked()) {
                    call_forward_unavai_cb_status = AppStrings.Constants.on;
                } else {
                    call_forward_unavai_cb_status = AppStrings.Constants.off;
                }
//                }
            }
        });
        call_forward_busy_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                if (call_forward_busy_cb.isPressed()) {

                if (call_forward_busy_cb.isChecked()) {
                    call_forward_busy_cb_status = AppStrings.Constants.on;
                } else {
                    call_forward_busy_cb_status = AppStrings.Constants.off;
                }
//                }
            }
        });
        call_forward_offline_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
//                if (call_forward_offline_cb.isPressed()) {

                if (call_forward_offline_cb.isChecked()) {
                    call_forward_offline_cb_status = AppStrings.Constants.on;
                } else {
                    call_forward_offline_cb_status = AppStrings.Constants.off;
                }
//                }
            }
        });

        back_iv.setOnClickListener(this);


        call_forward_always_spin.setSelection(1);
        call_forward_unavai_spin.setSelection(1);
        call_forward_busy_spin.setSelection(1);
        call_forward_offline_spin.setSelection(1);

        spinnerFunctionality(call_forward_always_spin, "1");
        spinnerFunctionality(call_forward_unavai_spin, "2");
        spinnerFunctionality(call_forward_busy_spin, "3");
        spinnerFunctionality(call_forward_offline_spin, "4");

        /*performing getCallforwad data*/
        getCallForwardingApiCall();
    }

    public void spinnerFunctionality(final Spinner spinner, final String type) {


        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(CallForwardingActivity.this, R.layout.custom_spinner, names_one_array) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }


        };

        spinner.setAdapter(arrayAdapter);

        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(spinner.getSelectedItem());


                SettingsId(type, names_one_id_array.get(position));


            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }

    public void SettingsId(String type, String id) {

        if (type.equals("1")) {
            callforward_always_time = id;

        } else if (type.equals("2")) {
            callforward_noanswer_time = id;

        } else if (type.equals("3")) {
            callforward_busy_time = id;

        } else if (type.equals("4")) {
            callforward_unreachable_time = id;
        }

    }


    public void updateCallForwardingApiCall() {

        if (AppMethods.isConnectingToInternet(CallForwardingActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.set_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.CallForwardInput.callforward_always_status, call_forward_always_cb_status);
                job.put(AppStrings.CallForwardInput.callforward_always_number, call_forward_always_tie.getText().toString());
                job.put(AppStrings.CallForwardInput.callforward_always_time, callforward_always_time);
                job.put(AppStrings.CallForwardInput.callforward_noanswer_status, call_forward_unavai_cb_status);

                job.put(AppStrings.CallForwardInput.callforward_noanswer_number, call_forward_unavai_tie.getText().toString());
                job.put(AppStrings.CallForwardInput.callforward_noanswer_time, callforward_noanswer_time);
                job.put(AppStrings.CallForwardInput.callforward_busy_status, call_forward_busy_cb_status);
                job.put(AppStrings.CallForwardInput.callforward_busy_number, call_forward_busy_tie.getText().toString());
                job.put(AppStrings.CallForwardInput.callforward_busy_time, callforward_busy_time);
                job.put(AppStrings.CallForwardInput.callforward_unreachable_status, call_forward_offline_cb_status);
                job.put(AppStrings.CallForwardInput.callforward_unreachable_number, call_forward_offline_tie.getText().toString());
                job.put(AppStrings.CallForwardInput.callforward_unreachable_time, callforward_unreachable_time);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.set_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(CallForwardingActivity.this);
        }
    }

    public void getCallForwardingApiCall() {

        if (AppMethods.isConnectingToInternet(CallForwardingActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.get_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();
                job.put(AppStrings.CallForwardInput.callforward_always_status, AppStrings.CallForwardInput.callforward_always_status);
                job.put(AppStrings.CallForwardInput.callforward_always_number, AppStrings.CallForwardInput.callforward_always_number);
                job.put(AppStrings.CallForwardInput.callforward_always_time, AppStrings.CallForwardInput.callforward_always_time);
                job.put(AppStrings.CallForwardInput.callforward_noanswer_status, AppStrings.CallForwardInput.callforward_noanswer_status);

                job.put(AppStrings.CallForwardInput.callforward_noanswer_number, AppStrings.CallForwardInput.callforward_noanswer_number);
                job.put(AppStrings.CallForwardInput.callforward_noanswer_time, AppStrings.CallForwardInput.callforward_noanswer_time);
                job.put(AppStrings.CallForwardInput.callforward_busy_status, AppStrings.CallForwardInput.callforward_busy_status);
                job.put(AppStrings.CallForwardInput.callforward_busy_number, AppStrings.CallForwardInput.callforward_busy_number);
                job.put(AppStrings.CallForwardInput.callforward_busy_time, AppStrings.CallForwardInput.callforward_busy_time);
                job.put(AppStrings.CallForwardInput.callforward_unreachable_status, AppStrings.CallForwardInput.callforward_unreachable_status);
                job.put(AppStrings.CallForwardInput.callforward_unreachable_number, AppStrings.CallForwardInput.callforward_unreachable_number);
                job.put(AppStrings.CallForwardInput.callforward_unreachable_time, AppStrings.CallForwardInput.callforward_unreachable_time);

                jo.put(AppStrings.InputParams.params, job);


            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(CallForwardingActivity.this);
        }
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.back_iv:
                try {
                    AppMethods.hideSoftKeyboard(this);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                /*updating Call forward data here*/
                updateCallForwardingApiCall();

                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        if (URL.equals(RestApis.get_voip_params)) {
            voicemailResponse(response, RestApis.get_voip_params);
        } else if (URL.equals(RestApis.set_voip_params)) {
            voicemailResponse(response, RestApis.set_voip_params);
        }
    }

    public void voicemailResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {


                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));

                    call_forward_always_cb_status = job.getString(AppStrings.CallForwardInput.callforward_always_status);
                    call_forward_unavai_cb_status = job.getString(AppStrings.CallForwardInput.callforward_noanswer_status);
                    call_forward_busy_cb_status = job.getString(AppStrings.CallForwardInput.callforward_busy_status);
                    call_forward_offline_cb_status = job.getString(AppStrings.CallForwardInput.callforward_unreachable_status);

                    call_forward_always_tie.setText(job.getString(AppStrings.CallForwardInput.callforward_always_number));
                    call_forward_unavai_tie.setText(job.getString(AppStrings.CallForwardInput.callforward_noanswer_number));
                    call_forward_busy_tie.setText(job.getString(AppStrings.CallForwardInput.callforward_busy_number));
                    call_forward_offline_tie.setText(job.getString(AppStrings.CallForwardInput.callforward_unreachable_number));

                    String callforward_always_time = job.getString(AppStrings.CallForwardInput.callforward_always_time);
                    String callforward_noanswer_time = job.getString(AppStrings.CallForwardInput.callforward_noanswer_time);
                    String callforward_busy_time = job.getString(AppStrings.CallForwardInput.callforward_busy_time);
                    String callforward_unreachable_time = job.getString(AppStrings.CallForwardInput.callforward_unreachable_time);


                    for (int i = 0; i < names_one_array.size(); i++) {
                        if (names_one_id_array.get(i).equals(callforward_always_time)) {
                            call_forward_always_spin.setSelection(i);

                        }
                    }
                    for (int i = 0; i < names_one_array.size(); i++) {
                        if (names_one_id_array.get(i).equals(callforward_noanswer_time)) {
                            call_forward_unavai_spin.setSelection(i);

                        }
                    }
                    for (int i = 0; i < names_one_array.size(); i++) {
                        if (names_one_id_array.get(i).equals(callforward_busy_time)) {
                            call_forward_busy_spin.setSelection(i);

                        }
                    }
                    for (int i = 0; i < names_one_array.size(); i++) {
                        if (names_one_id_array.get(i).equals(callforward_unreachable_time)) {
                            call_forward_offline_spin.setSelection(i);
                        }
                    }


                    call_forward_always_tie.setSelection(call_forward_always_tie.getText().length());
                    call_forward_unavai_tie.setSelection(call_forward_unavai_tie.getText().length());
                    call_forward_busy_tie.setSelection(call_forward_busy_tie.getText().length());
                    call_forward_offline_tie.setSelection(call_forward_offline_tie.getText().length());
                    checkingCheckboxesStatus();


                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);

                    finish();
                }

            } else {
                AppMethods.showToast(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void checkingCheckboxesStatus() {

        if (call_forward_always_cb_status.equals(AppStrings.Constants.on)) {
            call_forward_always_cb.setChecked(true);
        } else {
            call_forward_always_cb.setChecked(false);
        }
        if (call_forward_unavai_cb_status.equals(AppStrings.Constants.on)) {
            call_forward_unavai_cb.setChecked(true);
        } else {
            call_forward_unavai_cb.setChecked(false);
        }
        if (call_forward_busy_cb_status.equals(AppStrings.Constants.on)) {
            call_forward_busy_cb.setChecked(true);
        } else {
            call_forward_busy_cb.setChecked(false);
        }
        if (call_forward_offline_cb_status.equals(AppStrings.Constants.on)) {
            call_forward_offline_cb.setChecked(true);
        } else {
            call_forward_offline_cb.setChecked(false);
        }

    }

}
