package org.linphone.bluereach;

import static org.linphone.LinphoneApplication.coreContext;

import android.graphics.Color;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatEditText;

import org.json.JSONException;
import org.json.JSONObject;
import org.linphone.R;
import org.linphone.rest.AsyncHttpResponse;
import org.linphone.rest.RestApis;
import org.linphone.utils.AppMethods;
import org.linphone.utils.AppStrings;
import org.linphone.utils.SessionManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AutoAttendantActivity extends AppCompatActivity implements View.OnClickListener, AsyncHttpResponse.AsyncHttpResponseListener {
    AppCompatEditText digi0_et, digi1_et, digi2_et, digi3_et, digi4_et, digi5_et, digi6_et, digi7_et, digi8_et, digi9_et;
    SessionManager sessionManager;
    ImageView back_iv;
    TextView title_tv;
    private static final String TAG = "AutoAttendantActivity";
    CheckBox autoattendant_enable_cb, autoattendant_support_cb,ring_ph_cb;
    ArrayList<String> autoattendant_enable_name_array;
    ArrayList<String> autoattendant_enable_id_array;


    ArrayList<String> autoattendant_support_name_array;
    ArrayList<String> autoattendant_support_id_array;
    String autoattendant_enable_cb_status = "0", autoattendant_support_cb_status = "0",
            autoattendant_time_sp_status = "0", autoattendant_support_sp_status = "0",ring_ph_cb_status = "0";
    Spinner autoattendant_time_sp, autoattendant_support_sp;
    AppCompatEditText wait_time_et, play_mess_et, ring_ph_et, wait_max_digits_et;
    LinearLayout auto_message_ll;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_auto_attendant);
        init();

    }

    public void init() {

        sessionManager = new SessionManager(this);
        auto_message_ll = (LinearLayout) findViewById(R.id.auto_message_ll);
        ring_ph_cb = (CheckBox) findViewById(R.id.ring_ph_cb);
        autoattendant_enable_cb = (CheckBox) findViewById(R.id.autoattendant_enable_cb);
        autoattendant_support_cb = (CheckBox) findViewById(R.id.autoattendant_support_cb);
        autoattendant_time_sp = (Spinner) findViewById(R.id.autoattendant_time_sp);
        autoattendant_support_sp = (Spinner) findViewById(R.id.autoattendant_support_sp);
        title_tv = (TextView) findViewById(R.id.title_tv);
        back_iv = (ImageView) findViewById(R.id.back_iv);
        wait_time_et = (AppCompatEditText) findViewById(R.id.wait_time_et);
        play_mess_et = (AppCompatEditText) findViewById(R.id.play_mess_et);
        ring_ph_et = (AppCompatEditText) findViewById(R.id.ring_ph_et);
        wait_max_digits_et = (AppCompatEditText) findViewById(R.id.wait_max_digits_et);
//        wait_max_digits_et.setText("3");
        digi1_et = (AppCompatEditText) findViewById(R.id.digi1_et);
        digi2_et = (AppCompatEditText) findViewById(R.id.digi2_et);
        digi3_et = (AppCompatEditText) findViewById(R.id.digi3_et);
        digi4_et = (AppCompatEditText) findViewById(R.id.digi4_et);
        digi5_et = (AppCompatEditText) findViewById(R.id.digi5_et);
        digi6_et = (AppCompatEditText) findViewById(R.id.digi6_et);
        digi7_et = (AppCompatEditText) findViewById(R.id.digi7_et);
        digi8_et = (AppCompatEditText) findViewById(R.id.digi8_et);
        digi9_et = (AppCompatEditText) findViewById(R.id.digi9_et);
        digi0_et = (AppCompatEditText) findViewById(R.id.digi0_et);
        title_tv.setText(getString(R.string.auto_attendant));

        back_iv.setOnClickListener(this);
        autoattendant_enable_name_array = new ArrayList<>();
        autoattendant_support_name_array = new ArrayList<>();
        autoattendant_enable_id_array = new ArrayList<>();
        autoattendant_support_id_array = new ArrayList<>();


        List<String> name_one = Arrays.asList(getResources().getStringArray(R.array.call_forward_names));
        List<String> id_one = Arrays.asList(getResources().getStringArray(R.array.cal_forward_id));

        for (int i = 0; i < name_one.size(); i++) {
            autoattendant_enable_name_array.add(name_one.get(i));
        }
        for (int i = 0; i < id_one.size(); i++) {
            autoattendant_enable_id_array.add(id_one.get(i));
        }
        List<String> auto_support_name = Arrays.asList(getResources().getStringArray(R.array.auto_support_name));
        List<String> auto_support_id = Arrays.asList(getResources().getStringArray(R.array.auto_support_id));

        for (int i = 0; i < auto_support_name.size(); i++) {
            autoattendant_support_name_array.add(auto_support_name.get(i));
        }
        for (int i = 0; i < auto_support_id.size(); i++) {
            autoattendant_support_id_array.add(auto_support_id.get(i));
        }

        autoattendant_enable_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (autoattendant_enable_cb.isPressed()) {

                    if (autoattendant_enable_cb.isChecked()) {
                        autoattendant_enable_cb_status = AppStrings.Constants.on;
                    } else {
                        autoattendant_enable_cb_status = AppStrings.Constants.off;
                    }
                }
            }
        });
        ring_ph_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ring_ph_cb.isPressed()) {

                    if (ring_ph_cb.isChecked()) {
                        ring_ph_cb_status = AppStrings.Constants.on;
                    } else {
                        ring_ph_cb_status = AppStrings.Constants.off;
                    }
                }
            }
        });
        autoattendant_support_cb.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (autoattendant_support_cb.isPressed()) {

                    if (autoattendant_support_cb.isChecked()) {
                        autoattendant_support_cb_status = AppStrings.Constants.on;
                    } else {
                        autoattendant_support_cb_status = AppStrings.Constants.off;
                    }
                }
            }
        });
        auto_message_ll.setOnClickListener(this);

        spinnerFunctionality(autoattendant_time_sp, "1", autoattendant_enable_name_array);
        spinnerFunctionality(autoattendant_support_sp, "2", autoattendant_support_name_array);
        getSpeedDialApiCall();
    }

    public void getSpeedDialApiCall() {

        if (AppMethods.isConnectingToInternet(AutoAttendantActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.get_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();


                job.put(AppStrings.AutoAttendant.autoattendant_status, AppStrings.AutoAttendant.autoattendant_status);
                job.put(AppStrings.AutoAttendant.autoattendant_time, AppStrings.AutoAttendant.autoattendant_time);
                job.put(AppStrings.AutoAttendant.autoattendant_waittime, AppStrings.AutoAttendant.autoattendant_waittime);
                job.put(AppStrings.AutoAttendant.autoattendant_replay, AppStrings.AutoAttendant.autoattendant_replay);
                job.put(AppStrings.AutoAttendant.autoattendant_connect, AppStrings.AutoAttendant.autoattendant_connect);
                job.put(AppStrings.AutoAttendant.autoattendant_key1divert, AppStrings.AutoAttendant.autoattendant_key1divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key2divert, AppStrings.AutoAttendant.autoattendant_key2divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key3divert, AppStrings.AutoAttendant.autoattendant_key3divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key4divert, AppStrings.AutoAttendant.autoattendant_key4divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key5divert, AppStrings.AutoAttendant.autoattendant_key5divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key6divert, AppStrings.AutoAttendant.autoattendant_key6divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key7divert, AppStrings.AutoAttendant.autoattendant_key7divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key8divert, AppStrings.AutoAttendant.autoattendant_key8divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key9divert, AppStrings.AutoAttendant.autoattendant_key9divert);
                job.put(AppStrings.AutoAttendant.autoattendant_key0divert, AppStrings.AutoAttendant.autoattendant_key0divert);
                job.put(AppStrings.AutoAttendant.autoattendant_extdialenabled, AppStrings.AutoAttendant.autoattendant_extdialenabled);
                job.put(AppStrings.AutoAttendant.autoattendant_extdialdigit, AppStrings.AutoAttendant.autoattendant_extdialdigit);
                job.put(AppStrings.AutoAttendant.autoattendant_extdialmaxdigits, AppStrings.AutoAttendant.autoattendant_extdialmaxdigits);


                jo.put(AppStrings.InputParams.params, job);




            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.get_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(AutoAttendantActivity.this);
        }
    }

    public void updateAutoApiCall() {
        String max_digit = "";


        if (wait_max_digits_et.getText().toString().equals("")) {
            max_digit = "3";
        } else {
            max_digit = wait_max_digits_et.getText().toString();
        }

        if (AppMethods.isConnectingToInternet(AutoAttendantActivity.this)) {
            AsyncHttpResponse response = new AsyncHttpResponse(this, true);
            JSONObject jo = null;
            try {
                jo = new JSONObject();
                jo.put(AppStrings.InputParams.action, RestApis.set_voip_params);
                jo.put(AppStrings.InputParams.login, sessionManager.getStoreData(AppStrings.Session.login));
                jo.put(AppStrings.InputParams.password, sessionManager.getStoreData(AppStrings.Session.password));

                JSONObject job = new JSONObject();


                job.put(AppStrings.AutoAttendant.autoattendant_status, autoattendant_enable_cb_status);
                job.put(AppStrings.AutoAttendant.autoattendant_time, autoattendant_time_sp_status);
                job.put(AppStrings.AutoAttendant.autoattendant_waittime, wait_time_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_replay, play_mess_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_connect, ring_ph_cb_status);
                job.put(AppStrings.AutoAttendant.autoattendant_key1divert, digi1_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key2divert, digi2_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key3divert, digi3_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key4divert, digi4_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key5divert, digi5_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key6divert, digi6_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key7divert, digi7_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key8divert, digi8_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key9divert, digi9_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_key0divert, digi0_et.getText().toString());
                job.put(AppStrings.AutoAttendant.autoattendant_extdialenabled, autoattendant_support_cb_status);
                job.put(AppStrings.AutoAttendant.autoattendant_extdialdigit, autoattendant_support_sp_status);
                job.put(AppStrings.AutoAttendant.autoattendant_extdialmaxdigits, max_digit);


                jo.put(AppStrings.InputParams.params, job);



            } catch (Exception e) {
                e.printStackTrace();
            }
            response.postJsonAsyncHttp(RestApis.url, RestApis.set_voip_params, jo);
        } else {
            AppMethods.alertForNoInternet(AutoAttendantActivity.this);
        }
    }

    public void spinnerFunctionality(final Spinner spinner, final String type, ArrayList arrayList) {


        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(AutoAttendantActivity.this, R.layout.custom_spinner, arrayList) {
            public View getView(int position, View convertView, ViewGroup parent) {
                View v = super.getView(position, convertView, parent);
                ((TextView) v).setTextColor(getResources().getColor(R.color.black));
                ((TextView) v).setBackgroundColor(Color.TRANSPARENT);
                return v;
            }

            public View getDropDownView(int position, View convertView, ViewGroup parent) {
                View v = super.getDropDownView(position, convertView, parent);
                v.setBackgroundColor(getResources().getColor(R.color.white));

                ((TextView) v).setGravity(Gravity.LEFT);

                return v;
            }


        };

        spinner.setAdapter(arrayAdapter);

        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {


                String Text = String.valueOf(spinner.getSelectedItem());

                if (type.equals(AppStrings.Constants.on)) {
                    SettingsId(type, autoattendant_enable_id_array.get(position));


                } else if (type.equals(AppStrings.Constants.two)) {
                    SettingsId(type, autoattendant_support_id_array.get(position));
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.back_iv:
                updateAutoApiCall();

                break;


            case R.id.auto_message_ll:
                coreContext.auto_message(AppStrings.Constants.auto_message);
               // LinphoneManager.getInstance().newOutgoingCall(AppStrings.Constants.auto_message, "" + AppStrings.Constants.auto_message);
                finish();
                break;
        }
    }

    @Override
    public void onAsyncHttpResponseGet(String response, String URL) throws JSONException {
        autoResponse(response, URL);
    }


    public void SettingsId(String type, String id) {
        if (type.equals(AppStrings.Constants.on)) {
            autoattendant_time_sp_status = id;

        } else if (type.equals(AppStrings.Constants.two)) {
            autoattendant_support_sp_status = id;

        }

    }

    public void autoResponse(String response, String url) {
        try {
            JSONObject jo = new JSONObject(response);
            String Status = jo.optString(AppStrings.OutputParams.Status);
            String Message = jo.optString(AppStrings.OutputParams.Message);
            if (Status.equals(AppStrings.OutputParams.Success)) {


                if (url.equals(RestApis.get_voip_params)) {
                    JSONObject job = new JSONObject(jo.getString(AppStrings.InputParams.params));


                    autoattendant_enable_cb_status = job.getString(AppStrings.AutoAttendant.autoattendant_status);
                    autoattendant_time_sp_status = job.getString(AppStrings.AutoAttendant.autoattendant_time);
                    wait_time_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_waittime));
                    play_mess_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_replay));
                    ring_ph_cb_status=job.getString(AppStrings.AutoAttendant.autoattendant_connect);
                    digi1_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key1divert));
                    digi2_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key2divert));
                    digi3_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key3divert));
                    digi4_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key4divert));
                    digi5_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key5divert));
                    digi6_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key6divert));
                    digi7_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key7divert));
                    digi8_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key8divert));
                    digi9_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key9divert));
                    digi0_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_key0divert));
                    autoattendant_support_cb_status = job.getString(AppStrings.AutoAttendant.autoattendant_extdialenabled);
                    autoattendant_support_sp_status = job.getString(AppStrings.AutoAttendant.autoattendant_extdialdigit);
                    wait_max_digits_et.setText(job.getString(AppStrings.AutoAttendant.autoattendant_extdialmaxdigits));


                    setSelectionLength(wait_time_et);
                    setSelectionLength(play_mess_et);
                    setSelectionLength(ring_ph_et);
                    setSelectionLength(digi1_et);
                    setSelectionLength(digi2_et);
                    setSelectionLength(digi3_et);
                    setSelectionLength(digi4_et);
                    setSelectionLength(digi5_et);
                    setSelectionLength(digi6_et);
                    setSelectionLength(digi7_et);
                    setSelectionLength(digi8_et);
                    setSelectionLength(digi9_et);
                    setSelectionLength(digi0_et);
                    setSelectionLength(wait_max_digits_et);


                    for (int i = 0; i < autoattendant_enable_name_array.size(); i++) {
                        if (autoattendant_enable_id_array.get(i).equals(autoattendant_time_sp_status)) {
                            autoattendant_time_sp.setSelection(i);
                        }
                    }
                    for (int i = 0; i < autoattendant_support_name_array.size(); i++) {
                        if (autoattendant_support_id_array.get(i).equals(autoattendant_support_sp_status)) {
                            autoattendant_support_sp.setSelection(i);
                        }
                    }


                    checkingCheckboxesStatus();

                } else if (url.equals(RestApis.set_voip_params)) {
                    AppMethods.showToast(this, Message);
                    AppMethods.hideSoftKeyboard(this);
                    finish();
                }

            } else {
                AppMethods.showToast(this, Message);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void setSelectionLength(EditText editText) {
        editText.setSelection(editText.getText().length());
    }

    public void checkingCheckboxesStatus() {

        if (autoattendant_enable_cb_status.equals(AppStrings.Constants.on)) {

            autoattendant_enable_cb.setChecked(true);
        } else {
            autoattendant_enable_cb.setChecked(false);
        }

        if (autoattendant_support_cb_status.equals(AppStrings.Constants.on)) {

            autoattendant_support_cb.setChecked(true);

        } else {

            autoattendant_support_cb.setChecked(false);

        } if (ring_ph_cb_status.equals(AppStrings.Constants.on)) {

            ring_ph_cb.setChecked(true);
        } else {
            ring_ph_cb.setChecked(false);
        }


    }

}
