/*
 * Copyright (c) 2010-2020 Belledonne Communications SARL.
 *
 * This file is part of linphone-android
 * (see https://www.linphone.org).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.linphone.activities.assistant

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.view.KeyEvent
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import androidx.navigation.fragment.NavHostFragment
import com.google.android.material.snackbar.Snackbar
import org.linphone.R
import org.linphone.activities.GenericActivity
import org.linphone.activities.SnackBarActivity
import org.linphone.activities.assistant.viewmodels.SharedAssistantViewModel
import org.linphone.databinding.AssistantActivityBinding
import org.linphone.utils.AppMethods
import org.linphone.utils.SessionManager

class AssistantActivity : GenericActivity(), SnackBarActivity {
    private lateinit var binding: AssistantActivityBinding
    private lateinit var sharedViewModel: SharedAssistantViewModel
    lateinit var sm: SessionManager
    var keyStatus: Boolean = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = DataBindingUtil.setContentView(this, R.layout.assistant_activity)

        sharedViewModel = ViewModelProvider(this).get(SharedAssistantViewModel::class.java)

        sm = SessionManager(this)

        val navHostFragment =
            supportFragmentManager.findFragmentById(R.id.nav_host_fragment) as NavHostFragment
        val navController = navHostFragment.navController

        navController.navigate(R.id.genericAccountLoginFragment)
    }

    override fun showSnackBar(resourceId: Int) {
        Snackbar.make(binding.coordinator, resourceId, Snackbar.LENGTH_LONG).show()
    }

    override fun showSnackBar(message: String) {
        Snackbar.make(binding.coordinator, message, Snackbar.LENGTH_LONG).show()
    }

    override fun onBackPressed() {
        Log.e("tag", "onBackPressed:### " + sm.isUserLoggedIn)
        Log.e("tag", "onBackPressed: @@@")
        if (sm.isUserLoggedIn) {
            onBackPressed()
        } else {
            finish()
        }
    }

    override fun onKeyDown(keyCode: Int, event: KeyEvent?): Boolean {

        if (keyCode == KeyEvent.KEYCODE_BACK) {

            if (keyStatus) {

                onBackPressed1(this)
            } else
                AppMethods.showToast(
                    this,
                    getString(R.string.plz_click_back_to_exit)
                )
            keyStatus = true
            Handler(Looper.getMainLooper()).postDelayed({ keyStatus = false }, 2000)

            return true
        }
        return super.onKeyDown(keyCode, event)
    }

    fun onBackPressed1(context: Context) {
        val intent = Intent()
        intent.action = Intent.ACTION_MAIN
        intent.addCategory(Intent.CATEGORY_HOME)
        context.startActivity(intent)
    }
}
